/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.cosmos;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.spring.autoconfigure.cosmos.CosmosProperties;
import com.azure.spring.data.cosmos.config.AbstractCosmosConfiguration;
import com.azure.spring.data.cosmos.config.CosmosConfig;
import com.azure.spring.data.cosmos.core.CosmosTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={CosmosAsyncClient.class, CosmosTemplate.class})
@ConditionalOnResource(resources={"classpath:cosmos.enable.config"})
@EnableConfigurationProperties(value={CosmosProperties.class})
public class CosmosAutoConfiguration
extends AbstractCosmosConfiguration {
    private final CosmosProperties properties;

    public CosmosAutoConfiguration(CosmosProperties properties) {
        this.properties = properties;
    }

    protected String getDatabaseName() {
        return this.properties.getDatabase();
    }

    @Bean
    public AzureKeyCredential azureKeyCredential() {
        return new AzureKeyCredential(this.properties.getKey());
    }

    @Bean
    public CosmosClientBuilder cosmosClientBuilder(AzureKeyCredential azureKeyCredential) {
        CosmosClientBuilder cosmosClientBuilder = new CosmosClientBuilder();
        cosmosClientBuilder.credential(azureKeyCredential).consistencyLevel(this.properties.getConsistencyLevel()).endpoint(this.properties.getUri());
        if (ConnectionMode.GATEWAY == this.properties.getConnectionMode()) {
            cosmosClientBuilder.gatewayMode();
        }
        return cosmosClientBuilder;
    }

    public CosmosConfig cosmosConfig() {
        return CosmosConfig.builder().enableQueryMetrics(this.properties.isPopulateQueryMetrics()).responseDiagnosticsProcessor(this.properties.getResponseDiagnosticsProcessor()).build();
    }
}

