/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.AADAuthorizationGrantType;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.ClientAuthorizationRequiredException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AADAzureDelegatedOAuth2AuthorizedClientProvider
implements OAuth2AuthorizedClientProvider {
    private final Clock clock = Clock.systemUTC();
    private final Duration clockSkew = Duration.ofSeconds(60L);
    private final OAuth2AuthorizedClientProvider provider;
    private final OAuth2AuthorizedClientRepository authorizedClientRepository;

    public AADAzureDelegatedOAuth2AuthorizedClientProvider(RefreshTokenOAuth2AuthorizedClientProvider provider, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        this.provider = provider;
        this.authorizedClientRepository = authorizedClientRepository;
    }

    public OAuth2AuthorizedClient authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        ClientRegistration clientRegistration = context.getClientRegistration();
        if (!AADAuthorizationGrantType.AZURE_DELEGATED.isSameGrantType(clientRegistration.getAuthorizationGrantType())) {
            return null;
        }
        OAuth2AuthorizedClient authorizedClient = context.getAuthorizedClient();
        if (authorizedClient != null && this.tokenNotExpired((OAuth2Token)authorizedClient.getAccessToken())) {
            return null;
        }
        Authentication principal = context.getPrincipal();
        OAuth2AuthorizedClient azureClient = this.authorizedClientRepository.loadAuthorizedClient("azure", principal, AADAzureDelegatedOAuth2AuthorizedClientProvider.getHttpServletRequestOrDefault(context));
        if (azureClient == null) {
            throw new ClientAuthorizationRequiredException("azure");
        }
        OAuth2AuthorizedClient clientWithExpiredToken = this.createClientWithExpiredToken(azureClient, clientRegistration, principal);
        String[] scopes = clientRegistration.getScopes().toArray(new String[0]);
        OAuth2AuthorizationContext refreshTokenAuthorizationContext = OAuth2AuthorizationContext.withAuthorizedClient((OAuth2AuthorizedClient)clientWithExpiredToken).principal(principal).attributes(attributes -> attributes.put(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME, scopes)).build();
        return this.provider.authorize(refreshTokenAuthorizationContext);
    }

    private boolean tokenNotExpired(OAuth2Token token) {
        return Optional.ofNullable(token).map(OAuth2Token::getExpiresAt).map(expiredAt -> this.clock.instant().isBefore(expiredAt.minus(this.clockSkew))).orElse(false);
    }

    private OAuth2AuthorizedClient createClientWithExpiredToken(OAuth2AuthorizedClient azureClient, ClientRegistration clientRegistration, Authentication principal) {
        Assert.notNull((Object)azureClient, (String)"azureClient cannot be null");
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "non-access-token", Instant.MIN, Instant.now().minus(100L, ChronoUnit.DAYS));
        return new OAuth2AuthorizedClient(clientRegistration, principal.getName(), accessToken, azureClient.getRefreshToken());
    }

    private static HttpServletRequest getHttpServletRequestOrDefault(OAuth2AuthorizationContext context) {
        return Optional.ofNullable(context).map(OAuth2AuthorizationContext::getAttributes).map(attributes -> (HttpServletRequest)attributes.get(HttpServletRequest.class.getName())).orElseGet(AADAzureDelegatedOAuth2AuthorizedClientProvider::getDefaultHttpServletRequest);
    }

    private static HttpServletRequest getDefaultHttpServletRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(attributes -> attributes instanceof ServletRequestAttributes).map(attributes -> ((ServletRequestAttributes)attributes).getRequest()).orElse(null);
    }
}

