/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.NetworkInterfaceResourceNames;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualMachineResourceNames
implements JsonSerializable<VirtualMachineResourceNames> {
    private String vmName;
    private String hostName;
    private List<NetworkInterfaceResourceNames> networkInterfaces;
    private String osDiskName;
    private Map<String, List<String>> dataDiskNames;

    public String vmName() {
        return this.vmName;
    }

    public VirtualMachineResourceNames withVmName(String vmName) {
        this.vmName = vmName;
        return this;
    }

    public String hostName() {
        return this.hostName;
    }

    public VirtualMachineResourceNames withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public List<NetworkInterfaceResourceNames> networkInterfaces() {
        return this.networkInterfaces;
    }

    public VirtualMachineResourceNames withNetworkInterfaces(List<NetworkInterfaceResourceNames> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
        return this;
    }

    public String osDiskName() {
        return this.osDiskName;
    }

    public VirtualMachineResourceNames withOsDiskName(String osDiskName) {
        this.osDiskName = osDiskName;
        return this;
    }

    public Map<String, List<String>> dataDiskNames() {
        return this.dataDiskNames;
    }

    public VirtualMachineResourceNames withDataDiskNames(Map<String, List<String>> dataDiskNames) {
        this.dataDiskNames = dataDiskNames;
        return this;
    }

    public void validate() {
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmName", this.vmName);
        jsonWriter.writeStringField("hostName", this.hostName);
        jsonWriter.writeArrayField("networkInterfaces", this.networkInterfaces, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("osDiskName", this.osDiskName);
        jsonWriter.writeMapField("dataDiskNames", this.dataDiskNames, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeString(element1)));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineResourceNames fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineResourceNames)jsonReader.readObject(reader -> {
            VirtualMachineResourceNames deserializedVirtualMachineResourceNames = new VirtualMachineResourceNames();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmName".equals(fieldName)) {
                    deserializedVirtualMachineResourceNames.vmName = reader.getString();
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedVirtualMachineResourceNames.hostName = reader.getString();
                    continue;
                }
                if ("networkInterfaces".equals(fieldName)) {
                    List networkInterfaces;
                    deserializedVirtualMachineResourceNames.networkInterfaces = networkInterfaces = reader.readArray(reader1 -> NetworkInterfaceResourceNames.fromJson(reader1));
                    continue;
                }
                if ("osDiskName".equals(fieldName)) {
                    deserializedVirtualMachineResourceNames.osDiskName = reader.getString();
                    continue;
                }
                if ("dataDiskNames".equals(fieldName)) {
                    Map dataDiskNames;
                    deserializedVirtualMachineResourceNames.dataDiskNames = dataDiskNames = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineResourceNames;
        });
    }
}

