/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ApplicationServerConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.CentralServerConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DatabaseConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.HighAvailabilityConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.InfrastructureConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.NetworkConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDeploymentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StorageConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ThreeTierCustomResourceNames;
import java.io.IOException;

public final class ThreeTierConfiguration
extends InfrastructureConfiguration {
    private SapDeploymentType deploymentType = SapDeploymentType.THREE_TIER;
    private NetworkConfiguration networkConfiguration;
    private CentralServerConfiguration centralServer;
    private ApplicationServerConfiguration applicationServer;
    private DatabaseConfiguration databaseServer;
    private HighAvailabilityConfiguration highAvailabilityConfig;
    private StorageConfiguration storageConfiguration;
    private ThreeTierCustomResourceNames customResourceNames;
    private static final ClientLogger LOGGER = new ClientLogger(ThreeTierConfiguration.class);

    @Override
    public SapDeploymentType deploymentType() {
        return this.deploymentType;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public ThreeTierConfiguration withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public CentralServerConfiguration centralServer() {
        return this.centralServer;
    }

    public ThreeTierConfiguration withCentralServer(CentralServerConfiguration centralServer) {
        this.centralServer = centralServer;
        return this;
    }

    public ApplicationServerConfiguration applicationServer() {
        return this.applicationServer;
    }

    public ThreeTierConfiguration withApplicationServer(ApplicationServerConfiguration applicationServer) {
        this.applicationServer = applicationServer;
        return this;
    }

    public DatabaseConfiguration databaseServer() {
        return this.databaseServer;
    }

    public ThreeTierConfiguration withDatabaseServer(DatabaseConfiguration databaseServer) {
        this.databaseServer = databaseServer;
        return this;
    }

    public HighAvailabilityConfiguration highAvailabilityConfig() {
        return this.highAvailabilityConfig;
    }

    public ThreeTierConfiguration withHighAvailabilityConfig(HighAvailabilityConfiguration highAvailabilityConfig) {
        this.highAvailabilityConfig = highAvailabilityConfig;
        return this;
    }

    public StorageConfiguration storageConfiguration() {
        return this.storageConfiguration;
    }

    public ThreeTierConfiguration withStorageConfiguration(StorageConfiguration storageConfiguration) {
        this.storageConfiguration = storageConfiguration;
        return this;
    }

    public ThreeTierCustomResourceNames customResourceNames() {
        return this.customResourceNames;
    }

    public ThreeTierConfiguration withCustomResourceNames(ThreeTierCustomResourceNames customResourceNames) {
        this.customResourceNames = customResourceNames;
        return this;
    }

    @Override
    public ThreeTierConfiguration withAppResourceGroup(String appResourceGroup) {
        super.withAppResourceGroup(appResourceGroup);
        return this;
    }

    @Override
    public void validate() {
        if (this.networkConfiguration() != null) {
            this.networkConfiguration().validate();
        }
        if (this.centralServer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property centralServer in model ThreeTierConfiguration"));
        }
        this.centralServer().validate();
        if (this.applicationServer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property applicationServer in model ThreeTierConfiguration"));
        }
        this.applicationServer().validate();
        if (this.databaseServer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseServer in model ThreeTierConfiguration"));
        }
        this.databaseServer().validate();
        if (this.highAvailabilityConfig() != null) {
            this.highAvailabilityConfig().validate();
        }
        if (this.storageConfiguration() != null) {
            this.storageConfiguration().validate();
        }
        if (this.customResourceNames() != null) {
            this.customResourceNames().validate();
        }
        if (this.appResourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appResourceGroup in model ThreeTierConfiguration"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appResourceGroup", this.appResourceGroup());
        jsonWriter.writeJsonField("centralServer", (JsonSerializable)this.centralServer);
        jsonWriter.writeJsonField("applicationServer", (JsonSerializable)this.applicationServer);
        jsonWriter.writeJsonField("databaseServer", (JsonSerializable)this.databaseServer);
        jsonWriter.writeStringField("deploymentType", this.deploymentType == null ? null : this.deploymentType.toString());
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeJsonField("highAvailabilityConfig", (JsonSerializable)this.highAvailabilityConfig);
        jsonWriter.writeJsonField("storageConfiguration", (JsonSerializable)this.storageConfiguration);
        jsonWriter.writeJsonField("customResourceNames", (JsonSerializable)this.customResourceNames);
        return jsonWriter.writeEndObject();
    }

    public static ThreeTierConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ThreeTierConfiguration)jsonReader.readObject(reader -> {
            ThreeTierConfiguration deserializedThreeTierConfiguration = new ThreeTierConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appResourceGroup".equals(fieldName)) {
                    deserializedThreeTierConfiguration.withAppResourceGroup(reader.getString());
                    continue;
                }
                if ("centralServer".equals(fieldName)) {
                    deserializedThreeTierConfiguration.centralServer = CentralServerConfiguration.fromJson(reader);
                    continue;
                }
                if ("applicationServer".equals(fieldName)) {
                    deserializedThreeTierConfiguration.applicationServer = ApplicationServerConfiguration.fromJson(reader);
                    continue;
                }
                if ("databaseServer".equals(fieldName)) {
                    deserializedThreeTierConfiguration.databaseServer = DatabaseConfiguration.fromJson(reader);
                    continue;
                }
                if ("deploymentType".equals(fieldName)) {
                    deserializedThreeTierConfiguration.deploymentType = SapDeploymentType.fromString(reader.getString());
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    deserializedThreeTierConfiguration.networkConfiguration = NetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("highAvailabilityConfig".equals(fieldName)) {
                    deserializedThreeTierConfiguration.highAvailabilityConfig = HighAvailabilityConfiguration.fromJson(reader);
                    continue;
                }
                if ("storageConfiguration".equals(fieldName)) {
                    deserializedThreeTierConfiguration.storageConfiguration = StorageConfiguration.fromJson(reader);
                    continue;
                }
                if ("customResourceNames".equals(fieldName)) {
                    deserializedThreeTierConfiguration.customResourceNames = ThreeTierCustomResourceNames.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThreeTierConfiguration;
        });
    }
}

