/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.NamingPatternType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SingleServerCustomResourceNames;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.VirtualMachineResourceNames;
import java.io.IOException;

public final class SingleServerFullResourceNames
extends SingleServerCustomResourceNames {
    private NamingPatternType namingPatternType = NamingPatternType.FULL_RESOURCE_NAME;
    private VirtualMachineResourceNames virtualMachine;

    @Override
    public NamingPatternType namingPatternType() {
        return this.namingPatternType;
    }

    public VirtualMachineResourceNames virtualMachine() {
        return this.virtualMachine;
    }

    public SingleServerFullResourceNames withVirtualMachine(VirtualMachineResourceNames virtualMachine) {
        this.virtualMachine = virtualMachine;
        return this;
    }

    @Override
    public void validate() {
        if (this.virtualMachine() != null) {
            this.virtualMachine().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("namingPatternType", this.namingPatternType == null ? null : this.namingPatternType.toString());
        jsonWriter.writeJsonField("virtualMachine", (JsonSerializable)this.virtualMachine);
        return jsonWriter.writeEndObject();
    }

    public static SingleServerFullResourceNames fromJson(JsonReader jsonReader) throws IOException {
        return (SingleServerFullResourceNames)jsonReader.readObject(reader -> {
            SingleServerFullResourceNames deserializedSingleServerFullResourceNames = new SingleServerFullResourceNames();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("namingPatternType".equals(fieldName)) {
                    deserializedSingleServerFullResourceNames.namingPatternType = NamingPatternType.fromString(reader.getString());
                    continue;
                }
                if ("virtualMachine".equals(fieldName)) {
                    deserializedSingleServerFullResourceNames.virtualMachine = VirtualMachineResourceNames.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSingleServerFullResourceNames;
        });
    }
}

