/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ManagedRGConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ManagedResourcesNetworkAccessType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapEnvironmentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapHealthState;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapProductType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceError;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceState;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceStatus;
import java.io.IOException;

public final class SapVirtualInstanceProperties
implements JsonSerializable<SapVirtualInstanceProperties> {
    private SapEnvironmentType environment;
    private SapProductType sapProduct;
    private ManagedResourcesNetworkAccessType managedResourcesNetworkAccessType;
    private SapConfiguration configuration;
    private ManagedRGConfiguration managedResourceGroupConfiguration;
    private SapVirtualInstanceStatus status;
    private SapHealthState health;
    private SapVirtualInstanceState state;
    private SapVirtualInstanceProvisioningState provisioningState;
    private SapVirtualInstanceError errors;
    private static final ClientLogger LOGGER = new ClientLogger(SapVirtualInstanceProperties.class);

    public SapEnvironmentType environment() {
        return this.environment;
    }

    public SapVirtualInstanceProperties withEnvironment(SapEnvironmentType environment) {
        this.environment = environment;
        return this;
    }

    public SapProductType sapProduct() {
        return this.sapProduct;
    }

    public SapVirtualInstanceProperties withSapProduct(SapProductType sapProduct) {
        this.sapProduct = sapProduct;
        return this;
    }

    public ManagedResourcesNetworkAccessType managedResourcesNetworkAccessType() {
        return this.managedResourcesNetworkAccessType;
    }

    public SapVirtualInstanceProperties withManagedResourcesNetworkAccessType(ManagedResourcesNetworkAccessType managedResourcesNetworkAccessType) {
        this.managedResourcesNetworkAccessType = managedResourcesNetworkAccessType;
        return this;
    }

    public SapConfiguration configuration() {
        return this.configuration;
    }

    public SapVirtualInstanceProperties withConfiguration(SapConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ManagedRGConfiguration managedResourceGroupConfiguration() {
        return this.managedResourceGroupConfiguration;
    }

    public SapVirtualInstanceProperties withManagedResourceGroupConfiguration(ManagedRGConfiguration managedResourceGroupConfiguration) {
        this.managedResourceGroupConfiguration = managedResourceGroupConfiguration;
        return this;
    }

    public SapVirtualInstanceStatus status() {
        return this.status;
    }

    public SapHealthState health() {
        return this.health;
    }

    public SapVirtualInstanceState state() {
        return this.state;
    }

    public SapVirtualInstanceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SapVirtualInstanceError errors() {
        return this.errors;
    }

    public void validate() {
        if (this.environment() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property environment in model SapVirtualInstanceProperties"));
        }
        if (this.sapProduct() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sapProduct in model SapVirtualInstanceProperties"));
        }
        if (this.configuration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property configuration in model SapVirtualInstanceProperties"));
        }
        this.configuration().validate();
        if (this.managedResourceGroupConfiguration() != null) {
            this.managedResourceGroupConfiguration().validate();
        }
        if (this.errors() != null) {
            this.errors().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environment", this.environment == null ? null : this.environment.toString());
        jsonWriter.writeStringField("sapProduct", this.sapProduct == null ? null : this.sapProduct.toString());
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeStringField("managedResourcesNetworkAccessType", this.managedResourcesNetworkAccessType == null ? null : this.managedResourcesNetworkAccessType.toString());
        jsonWriter.writeJsonField("managedResourceGroupConfiguration", (JsonSerializable)this.managedResourceGroupConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static SapVirtualInstanceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SapVirtualInstanceProperties)jsonReader.readObject(reader -> {
            SapVirtualInstanceProperties deserializedSapVirtualInstanceProperties = new SapVirtualInstanceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("environment".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.environment = SapEnvironmentType.fromString(reader.getString());
                    continue;
                }
                if ("sapProduct".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.sapProduct = SapProductType.fromString(reader.getString());
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.configuration = SapConfiguration.fromJson(reader);
                    continue;
                }
                if ("managedResourcesNetworkAccessType".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.managedResourcesNetworkAccessType = ManagedResourcesNetworkAccessType.fromString(reader.getString());
                    continue;
                }
                if ("managedResourceGroupConfiguration".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.managedResourceGroupConfiguration = ManagedRGConfiguration.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.status = SapVirtualInstanceStatus.fromString(reader.getString());
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.health = SapHealthState.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.state = SapVirtualInstanceState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.provisioningState = SapVirtualInstanceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedSapVirtualInstanceProperties.errors = SapVirtualInstanceError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapVirtualInstanceProperties;
        });
    }
}

