/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapVirtualInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SAPVirtualInstanceIdentity;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UpdateSapVirtualInstanceProperties;
import java.util.Map;

public interface SapVirtualInstance {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SapVirtualInstanceProperties properties();

    public SAPVirtualInstanceIdentity identity();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public SapVirtualInstanceInner innerModel();

    public Update update();

    public SapVirtualInstance refresh();

    public SapVirtualInstance refresh(Context var1);

    public OperationStatusResult start();

    public OperationStatusResult start(StartRequest var1, Context var2);

    public OperationStatusResult stop();

    public OperationStatusResult stop(StopRequest var1, Context var2);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(UpdateSapVirtualInstanceProperties var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(SAPVirtualInstanceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithProperties {
        public SapVirtualInstance apply();

        public SapVirtualInstance apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIdentity {
            public WithCreate withIdentity(SAPVirtualInstanceIdentity var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(SapVirtualInstanceProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithIdentity {
            public SapVirtualInstance create();

            public SapVirtualInstance create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

