/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SAPVirtualInstanceIdentityType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.Map;

public final class SAPVirtualInstanceIdentity
implements JsonSerializable<SAPVirtualInstanceIdentity> {
    private SAPVirtualInstanceIdentityType type;
    private Map<String, UserAssignedIdentity> userAssignedIdentities;
    private static final ClientLogger LOGGER = new ClientLogger(SAPVirtualInstanceIdentity.class);

    public SAPVirtualInstanceIdentityType type() {
        return this.type;
    }

    public SAPVirtualInstanceIdentity withType(SAPVirtualInstanceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserAssignedIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public SAPVirtualInstanceIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model SAPVirtualInstanceIdentity"));
        }
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SAPVirtualInstanceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (SAPVirtualInstanceIdentity)jsonReader.readObject(reader -> {
            SAPVirtualInstanceIdentity deserializedSAPVirtualInstanceIdentity = new SAPVirtualInstanceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSAPVirtualInstanceIdentity.type = SAPVirtualInstanceIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedSAPVirtualInstanceIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSAPVirtualInstanceIdentity;
        });
    }
}

