/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapHealthState;
import java.io.IOException;

public final class MessageServerProperties
implements JsonSerializable<MessageServerProperties> {
    private Long msPort;
    private Long internalMsPort;
    private Long httpPort;
    private Long httpsPort;
    private String hostname;
    private String ipAddress;
    private SapHealthState health;

    public Long msPort() {
        return this.msPort;
    }

    public Long internalMsPort() {
        return this.internalMsPort;
    }

    public Long httpPort() {
        return this.httpPort;
    }

    public Long httpsPort() {
        return this.httpsPort;
    }

    public String hostname() {
        return this.hostname;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public SapHealthState health() {
        return this.health;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MessageServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MessageServerProperties)jsonReader.readObject(reader -> {
            MessageServerProperties deserializedMessageServerProperties = new MessageServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("msPort".equals(fieldName)) {
                    deserializedMessageServerProperties.msPort = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("internalMsPort".equals(fieldName)) {
                    deserializedMessageServerProperties.internalMsPort = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("httpPort".equals(fieldName)) {
                    deserializedMessageServerProperties.httpPort = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("httpsPort".equals(fieldName)) {
                    deserializedMessageServerProperties.httpsPort = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("hostname".equals(fieldName)) {
                    deserializedMessageServerProperties.hostname = reader.getString();
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedMessageServerProperties.ipAddress = reader.getString();
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedMessageServerProperties.health = SapHealthState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMessageServerProperties;
        });
    }
}

