/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapHighAvailabilityType;
import java.io.IOException;

public final class HighAvailabilityConfiguration
implements JsonSerializable<HighAvailabilityConfiguration> {
    private SapHighAvailabilityType highAvailabilityType;
    private static final ClientLogger LOGGER = new ClientLogger(HighAvailabilityConfiguration.class);

    public SapHighAvailabilityType highAvailabilityType() {
        return this.highAvailabilityType;
    }

    public HighAvailabilityConfiguration withHighAvailabilityType(SapHighAvailabilityType highAvailabilityType) {
        this.highAvailabilityType = highAvailabilityType;
        return this;
    }

    public void validate() {
        if (this.highAvailabilityType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property highAvailabilityType in model HighAvailabilityConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("highAvailabilityType", this.highAvailabilityType == null ? null : this.highAvailabilityType.toString());
        return jsonWriter.writeEndObject();
    }

    public static HighAvailabilityConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (HighAvailabilityConfiguration)jsonReader.readObject(reader -> {
            HighAvailabilityConfiguration deserializedHighAvailabilityConfiguration = new HighAvailabilityConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("highAvailabilityType".equals(fieldName)) {
                    deserializedHighAvailabilityConfiguration.highAvailabilityType = SapHighAvailabilityType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHighAvailabilityConfiguration;
        });
    }
}

