/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ErrorDefinition
implements JsonSerializable<ErrorDefinition> {
    private String code;
    private String message;
    private List<ErrorDefinition> details;

    private ErrorDefinition() {
    }

    public String code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public List<ErrorDefinition> details() {
        return this.details;
    }

    public void validate() {
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ErrorDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ErrorDefinition)jsonReader.readObject(reader -> {
            ErrorDefinition deserializedErrorDefinition = new ErrorDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedErrorDefinition.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedErrorDefinition.message = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedErrorDefinition.details = details = reader.readArray(reader1 -> ErrorDefinition.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedErrorDefinition;
        });
    }
}

