/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.InfrastructureConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapConfigurationType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SoftwareConfiguration;
import java.io.IOException;

public final class DeploymentConfiguration
extends SapConfiguration {
    private SapConfigurationType configurationType = SapConfigurationType.DEPLOYMENT;
    private String appLocation;
    private InfrastructureConfiguration infrastructureConfiguration;
    private SoftwareConfiguration softwareConfiguration;

    @Override
    public SapConfigurationType configurationType() {
        return this.configurationType;
    }

    public String appLocation() {
        return this.appLocation;
    }

    public DeploymentConfiguration withAppLocation(String appLocation) {
        this.appLocation = appLocation;
        return this;
    }

    public InfrastructureConfiguration infrastructureConfiguration() {
        return this.infrastructureConfiguration;
    }

    public DeploymentConfiguration withInfrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration) {
        this.infrastructureConfiguration = infrastructureConfiguration;
        return this;
    }

    public SoftwareConfiguration softwareConfiguration() {
        return this.softwareConfiguration;
    }

    public DeploymentConfiguration withSoftwareConfiguration(SoftwareConfiguration softwareConfiguration) {
        this.softwareConfiguration = softwareConfiguration;
        return this;
    }

    @Override
    public void validate() {
        if (this.infrastructureConfiguration() != null) {
            this.infrastructureConfiguration().validate();
        }
        if (this.softwareConfiguration() != null) {
            this.softwareConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        jsonWriter.writeStringField("appLocation", this.appLocation);
        jsonWriter.writeJsonField("infrastructureConfiguration", (JsonSerializable)this.infrastructureConfiguration);
        jsonWriter.writeJsonField("softwareConfiguration", (JsonSerializable)this.softwareConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentConfiguration)jsonReader.readObject(reader -> {
            DeploymentConfiguration deserializedDeploymentConfiguration = new DeploymentConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configurationType".equals(fieldName)) {
                    deserializedDeploymentConfiguration.configurationType = SapConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("appLocation".equals(fieldName)) {
                    deserializedDeploymentConfiguration.appLocation = reader.getString();
                    continue;
                }
                if ("infrastructureConfiguration".equals(fieldName)) {
                    deserializedDeploymentConfiguration.infrastructureConfiguration = InfrastructureConfiguration.fromJson(reader);
                    continue;
                }
                if ("softwareConfiguration".equals(fieldName)) {
                    deserializedDeploymentConfiguration.softwareConfiguration = SoftwareConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentConfiguration;
        });
    }
}

