/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceStatus;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StorageInformation;
import java.io.IOException;
import java.util.List;

public final class DatabaseVmDetails
implements JsonSerializable<DatabaseVmDetails> {
    private String virtualMachineId;
    private SapVirtualInstanceStatus status;
    private List<StorageInformation> storageDetails;

    private DatabaseVmDetails() {
    }

    public String virtualMachineId() {
        return this.virtualMachineId;
    }

    public SapVirtualInstanceStatus status() {
        return this.status;
    }

    public List<StorageInformation> storageDetails() {
        return this.storageDetails;
    }

    public void validate() {
        if (this.storageDetails() != null) {
            this.storageDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DatabaseVmDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseVmDetails)jsonReader.readObject(reader -> {
            DatabaseVmDetails deserializedDatabaseVmDetails = new DatabaseVmDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualMachineId".equals(fieldName)) {
                    deserializedDatabaseVmDetails.virtualMachineId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDatabaseVmDetails.status = SapVirtualInstanceStatus.fromString(reader.getString());
                    continue;
                }
                if ("storageDetails".equals(fieldName)) {
                    List storageDetails;
                    deserializedDatabaseVmDetails.storageDetails = storageDetails = reader.readArray(reader1 -> StorageInformation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseVmDetails;
        });
    }
}

