/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.LoadBalancerResourceNames;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.VirtualMachineResourceNames;
import java.io.IOException;
import java.util.List;

public final class DatabaseServerFullResourceNames
implements JsonSerializable<DatabaseServerFullResourceNames> {
    private List<VirtualMachineResourceNames> virtualMachines;
    private String availabilitySetName;
    private LoadBalancerResourceNames loadBalancer;

    public List<VirtualMachineResourceNames> virtualMachines() {
        return this.virtualMachines;
    }

    public DatabaseServerFullResourceNames withVirtualMachines(List<VirtualMachineResourceNames> virtualMachines) {
        this.virtualMachines = virtualMachines;
        return this;
    }

    public String availabilitySetName() {
        return this.availabilitySetName;
    }

    public DatabaseServerFullResourceNames withAvailabilitySetName(String availabilitySetName) {
        this.availabilitySetName = availabilitySetName;
        return this;
    }

    public LoadBalancerResourceNames loadBalancer() {
        return this.loadBalancer;
    }

    public DatabaseServerFullResourceNames withLoadBalancer(LoadBalancerResourceNames loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    public void validate() {
        if (this.virtualMachines() != null) {
            this.virtualMachines().forEach(e -> e.validate());
        }
        if (this.loadBalancer() != null) {
            this.loadBalancer().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("virtualMachines", this.virtualMachines, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("availabilitySetName", this.availabilitySetName);
        jsonWriter.writeJsonField("loadBalancer", (JsonSerializable)this.loadBalancer);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseServerFullResourceNames fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseServerFullResourceNames)jsonReader.readObject(reader -> {
            DatabaseServerFullResourceNames deserializedDatabaseServerFullResourceNames = new DatabaseServerFullResourceNames();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualMachines".equals(fieldName)) {
                    List virtualMachines;
                    deserializedDatabaseServerFullResourceNames.virtualMachines = virtualMachines = reader.readArray(reader1 -> VirtualMachineResourceNames.fromJson(reader1));
                    continue;
                }
                if ("availabilitySetName".equals(fieldName)) {
                    deserializedDatabaseServerFullResourceNames.availabilitySetName = reader.getString();
                    continue;
                }
                if ("loadBalancer".equals(fieldName)) {
                    deserializedDatabaseServerFullResourceNames.loadBalancer = LoadBalancerResourceNames.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseServerFullResourceNames;
        });
    }
}

