/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.VirtualMachineConfiguration;
import java.io.IOException;

public final class ApplicationServerConfiguration
implements JsonSerializable<ApplicationServerConfiguration> {
    private String subnetId;
    private VirtualMachineConfiguration virtualMachineConfiguration;
    private long instanceCount;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationServerConfiguration.class);

    public String subnetId() {
        return this.subnetId;
    }

    public ApplicationServerConfiguration withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public VirtualMachineConfiguration virtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    public ApplicationServerConfiguration withVirtualMachineConfiguration(VirtualMachineConfiguration virtualMachineConfiguration) {
        this.virtualMachineConfiguration = virtualMachineConfiguration;
        return this;
    }

    public long instanceCount() {
        return this.instanceCount;
    }

    public ApplicationServerConfiguration withInstanceCount(long instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public void validate() {
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model ApplicationServerConfiguration"));
        }
        if (this.virtualMachineConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualMachineConfiguration in model ApplicationServerConfiguration"));
        }
        this.virtualMachineConfiguration().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeJsonField("virtualMachineConfiguration", (JsonSerializable)this.virtualMachineConfiguration);
        jsonWriter.writeLongField("instanceCount", this.instanceCount);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationServerConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationServerConfiguration)jsonReader.readObject(reader -> {
            ApplicationServerConfiguration deserializedApplicationServerConfiguration = new ApplicationServerConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    deserializedApplicationServerConfiguration.subnetId = reader.getString();
                    continue;
                }
                if ("virtualMachineConfiguration".equals(fieldName)) {
                    deserializedApplicationServerConfiguration.virtualMachineConfiguration = VirtualMachineConfiguration.fromJson(reader);
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedApplicationServerConfiguration.instanceCount = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationServerConfiguration;
        });
    }
}

