/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadssapvirtualinstance.WorkloadsSapVirtualInstanceManager;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapDatabaseInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseInstance;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UpdateSapDatabaseInstanceRequest;
import java.util.Collections;
import java.util.Map;

public final class SapDatabaseInstanceImpl
implements SapDatabaseInstance,
SapDatabaseInstance.Definition,
SapDatabaseInstance.Update {
    private SapDatabaseInstanceInner innerObject;
    private final WorkloadsSapVirtualInstanceManager serviceManager;
    private String resourceGroupName;
    private String sapVirtualInstanceName;
    private String databaseInstanceName;
    private UpdateSapDatabaseInstanceRequest updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SapDatabaseProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SapDatabaseInstanceInner innerModel() {
        return this.innerObject;
    }

    private WorkloadsSapVirtualInstanceManager manager() {
        return this.serviceManager;
    }

    @Override
    public SapDatabaseInstanceImpl withExistingSapVirtualInstance(String resourceGroupName, String sapVirtualInstanceName) {
        this.resourceGroupName = resourceGroupName;
        this.sapVirtualInstanceName = sapVirtualInstanceName;
        return this;
    }

    @Override
    public SapDatabaseInstance create() {
        this.innerObject = this.serviceManager.serviceClient().getSapDatabaseInstances().create(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SapDatabaseInstance create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSapDatabaseInstances().create(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName, this.innerModel(), context);
        return this;
    }

    SapDatabaseInstanceImpl(String name, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerObject = new SapDatabaseInstanceInner();
        this.serviceManager = serviceManager;
        this.databaseInstanceName = name;
    }

    @Override
    public SapDatabaseInstanceImpl update() {
        this.updateProperties = new UpdateSapDatabaseInstanceRequest();
        return this;
    }

    @Override
    public SapDatabaseInstance apply() {
        this.innerObject = (SapDatabaseInstanceInner)((Object)this.serviceManager.serviceClient().getSapDatabaseInstances().updateWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public SapDatabaseInstance apply(Context context) {
        this.innerObject = (SapDatabaseInstanceInner)((Object)this.serviceManager.serviceClient().getSapDatabaseInstances().updateWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName, this.updateProperties, context).getValue());
        return this;
    }

    SapDatabaseInstanceImpl(SapDatabaseInstanceInner innerObject, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sapVirtualInstances");
        this.databaseInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "databaseInstances");
    }

    @Override
    public SapDatabaseInstance refresh() {
        this.innerObject = (SapDatabaseInstanceInner)((Object)this.serviceManager.serviceClient().getSapDatabaseInstances().getWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SapDatabaseInstance refresh(Context context) {
        this.innerObject = (SapDatabaseInstanceInner)((Object)this.serviceManager.serviceClient().getSapDatabaseInstances().getWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult start() {
        return this.serviceManager.sapDatabaseInstances().start(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName);
    }

    @Override
    public OperationStatusResult start(StartRequest body, Context context) {
        return this.serviceManager.sapDatabaseInstances().start(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName, body, context);
    }

    @Override
    public OperationStatusResult stop() {
        return this.serviceManager.sapDatabaseInstances().stop(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName);
    }

    @Override
    public OperationStatusResult stop(StopRequest body, Context context) {
        return this.serviceManager.sapDatabaseInstances().stop(this.resourceGroupName, this.sapVirtualInstanceName, this.databaseInstanceName, body, context);
    }

    @Override
    public SapDatabaseInstanceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SapDatabaseInstanceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SapDatabaseInstanceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public SapDatabaseInstanceImpl withProperties(SapDatabaseProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

