/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadssapvirtualinstance.WorkloadsSapVirtualInstanceManager;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.SapCentralServerInstancesClient;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapCentralServerInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.SapCentralServerInstanceImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapCentralServerInstance;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapCentralServerInstances;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;

public final class SapCentralServerInstancesImpl
implements SapCentralServerInstances {
    private static final ClientLogger LOGGER = new ClientLogger(SapCentralServerInstancesImpl.class);
    private final SapCentralServerInstancesClient innerClient;
    private final WorkloadsSapVirtualInstanceManager serviceManager;

    public SapCentralServerInstancesImpl(SapCentralServerInstancesClient innerClient, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SapCentralServerInstance> getWithResponse(String resourceGroupName, String sapVirtualInstanceName, String centralInstanceName, Context context) {
        Response<SapCentralServerInstanceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, sapVirtualInstanceName, centralInstanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SapCentralServerInstanceImpl((SapCentralServerInstanceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SapCentralServerInstance get(String resourceGroupName, String sapVirtualInstanceName, String centralInstanceName) {
        SapCentralServerInstanceInner inner = this.serviceClient().get(resourceGroupName, sapVirtualInstanceName, centralInstanceName);
        if (inner != null) {
            return new SapCentralServerInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String sapVirtualInstanceName, String centralInstanceName) {
        this.serviceClient().delete(resourceGroupName, sapVirtualInstanceName, centralInstanceName);
    }

    @Override
    public void delete(String resourceGroupName, String sapVirtualInstanceName, String centralInstanceName, Context context) {
        this.serviceClient().delete(resourceGroupName, sapVirtualInstanceName, centralInstanceName, context);
    }

    @Override
    public PagedIterable<SapCentralServerInstance> list(String resourceGroupName, String sapVirtualInstanceName) {
        PagedIterable<SapCentralServerInstanceInner> inner = this.serviceClient().list(resourceGroupName, sapVirtualInstanceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapCentralServerInstanceImpl((SapCentralServerInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SapCentralServerInstance> list(String resourceGroupName, String sapVirtualInstanceName, Context context) {
        PagedIterable<SapCentralServerInstanceInner> inner = this.serviceClient().list(resourceGroupName, sapVirtualInstanceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapCentralServerInstanceImpl((SapCentralServerInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String sapVirtualInstanceName, String centralInstanceName) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, sapVirtualInstanceName, centralInstanceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String sapVirtualInstanceName, String centralInstanceName, StartRequest body, Context context) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, sapVirtualInstanceName, centralInstanceName, body, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult stop(String resourceGroupName, String sapVirtualInstanceName, String centralInstanceName) {
        OperationStatusResultInner inner = this.serviceClient().stop(resourceGroupName, sapVirtualInstanceName, centralInstanceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult stop(String resourceGroupName, String sapVirtualInstanceName, String centralInstanceName, StopRequest body, Context context) {
        OperationStatusResultInner inner = this.serviceClient().stop(resourceGroupName, sapVirtualInstanceName, centralInstanceName, body, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SapCentralServerInstance getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String centralInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "centralInstances");
        if (centralInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'centralInstances'.", id)));
        }
        return (SapCentralServerInstance)this.getWithResponse(resourceGroupName, sapVirtualInstanceName, centralInstanceName, Context.NONE).getValue();
    }

    @Override
    public Response<SapCentralServerInstance> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String centralInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "centralInstances");
        if (centralInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'centralInstances'.", id)));
        }
        return this.getWithResponse(resourceGroupName, sapVirtualInstanceName, centralInstanceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String centralInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "centralInstances");
        if (centralInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'centralInstances'.", id)));
        }
        this.delete(resourceGroupName, sapVirtualInstanceName, centralInstanceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String centralInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "centralInstances");
        if (centralInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'centralInstances'.", id)));
        }
        this.delete(resourceGroupName, sapVirtualInstanceName, centralInstanceName, context);
    }

    private SapCentralServerInstancesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadsSapVirtualInstanceManager manager() {
        return this.serviceManager;
    }

    @Override
    public SapCentralServerInstanceImpl define(String name) {
        return new SapCentralServerInstanceImpl(name, this.manager());
    }
}

