/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapApplicationServerProperties;
import java.io.IOException;
import java.util.Map;

public final class SapApplicationServerInstanceInner
extends Resource {
    private SapApplicationServerProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public SapApplicationServerProperties properties() {
        return this.properties;
    }

    public SapApplicationServerInstanceInner withProperties(SapApplicationServerProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SapApplicationServerInstanceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SapApplicationServerInstanceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static SapApplicationServerInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return (SapApplicationServerInstanceInner)((Object)jsonReader.readObject(reader -> {
            SapApplicationServerInstanceInner deserializedSapApplicationServerInstanceInner = new SapApplicationServerInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSapApplicationServerInstanceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSapApplicationServerInstanceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapApplicationServerInstanceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSapApplicationServerInstanceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSapApplicationServerInstanceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSapApplicationServerInstanceInner.properties = SapApplicationServerProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSapApplicationServerInstanceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapApplicationServerInstanceInner;
        }));
    }
}

