/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.trafficmanager.models.HeatMapEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficFlow;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class HeatMapModelInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(HeatMapModelInner.class);
    @JsonProperty(value="properties.startTime")
    private OffsetDateTime startTime;
    @JsonProperty(value="properties.endTime")
    private OffsetDateTime endTime;
    @JsonProperty(value="properties.endpoints")
    private List<HeatMapEndpoint> endpoints;
    @JsonProperty(value="properties.trafficFlows")
    private List<TrafficFlow> trafficFlows;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private String type;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public HeatMapModelInner withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public HeatMapModelInner withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<HeatMapEndpoint> endpoints() {
        return this.endpoints;
    }

    public HeatMapModelInner withEndpoints(List<HeatMapEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public List<TrafficFlow> trafficFlows() {
        return this.trafficFlows;
    }

    public HeatMapModelInner withTrafficFlows(List<TrafficFlow> trafficFlows) {
        this.trafficFlows = trafficFlows;
        return this;
    }

    public String id() {
        return this.id;
    }

    public HeatMapModelInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public HeatMapModelInner withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public HeatMapModelInner withType(String type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.trafficFlows() != null) {
            this.trafficFlows().forEach(e -> e.validate());
        }
    }
}

