/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.test.utils;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.test.TestMode;
import com.azure.core.test.utils.MockTokenCredential;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.identity.AzureCliCredentialBuilder;
import com.azure.identity.AzureDeveloperCliCredentialBuilder;
import com.azure.identity.AzurePipelinesCredentialBuilder;
import com.azure.identity.AzurePowerShellCredentialBuilder;
import com.azure.identity.ChainedTokenCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.identity.EnvironmentCredentialBuilder;
import java.util.Iterator;

public final class TestUtilities {
    private TestUtilities() {
    }

    public static void sleep(int milliseconds, boolean isRecordMode) {
        if (isRecordMode) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> int getSize(Iterable<T> iterable) {
        int res = 0;
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++res;
        }
        return res;
    }

    public static <T> boolean isEmpty(PagedIterable<T> iterable) {
        return !iterable.iterator().hasNext();
    }

    public static TokenCredential getTokenCredentialForTest(TestMode testMode) {
        if (testMode == TestMode.LIVE) {
            Configuration config = Configuration.getGlobalConfiguration();
            ChainedTokenCredentialBuilder builder = new ChainedTokenCredentialBuilder().addLast((TokenCredential)new EnvironmentCredentialBuilder().build()).addLast((TokenCredential)new AzureCliCredentialBuilder().build()).addLast((TokenCredential)new AzureDeveloperCliCredentialBuilder().build());
            String serviceConnectionId = config.get("AZURESUBSCRIPTION_SERVICE_CONNECTION_ID");
            String clientId = config.get("AZURESUBSCRIPTION_CLIENT_ID");
            String tenantId = config.get("AZURESUBSCRIPTION_TENANT_ID");
            String systemAccessToken = config.get("SYSTEM_ACCESSTOKEN");
            if (!(CoreUtils.isNullOrEmpty((CharSequence)serviceConnectionId) || CoreUtils.isNullOrEmpty((CharSequence)clientId) || CoreUtils.isNullOrEmpty((CharSequence)tenantId) || CoreUtils.isNullOrEmpty((CharSequence)systemAccessToken))) {
                builder.addLast((TokenCredential)((AzurePipelinesCredentialBuilder)((AzurePipelinesCredentialBuilder)new AzurePipelinesCredentialBuilder().systemAccessToken(systemAccessToken).clientId(clientId)).tenantId(tenantId)).serviceConnectionId(serviceConnectionId).build());
            }
            builder.addLast((TokenCredential)new AzurePowerShellCredentialBuilder().build());
            return builder.build();
        }
        if (testMode == TestMode.RECORD) {
            return new DefaultAzureCredentialBuilder().build();
        }
        return new MockTokenCredential();
    }
}

