/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.ResourceSkuInner;
import java.io.IOException;
import java.util.List;

public final class ResourceSkusResult
implements JsonSerializable<ResourceSkusResult> {
    private String nextLink;
    private List<ResourceSkuInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ResourceSkusResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ResourceSkuInner> value() {
        return this.value;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkusResult fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSkusResult)jsonReader.readObject(reader -> {
            ResourceSkusResult deserializedResourceSkusResult = new ResourceSkusResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceSkusResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceSkusResult.value = value = reader.readArray(reader1 -> ResourceSkuInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkusResult;
        });
    }
}

