/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.PrimingJobState;
import java.io.IOException;

public final class PrimingJob
implements JsonSerializable<PrimingJob> {
    private String primingJobName;
    private String primingManifestUrl;
    private String primingJobId;
    private PrimingJobState primingJobState;
    private String primingJobStatus;
    private String primingJobDetails;
    private Double primingJobPercentComplete;
    private static final ClientLogger LOGGER = new ClientLogger(PrimingJob.class);

    public String primingJobName() {
        return this.primingJobName;
    }

    public PrimingJob withPrimingJobName(String primingJobName) {
        this.primingJobName = primingJobName;
        return this;
    }

    public String primingManifestUrl() {
        return this.primingManifestUrl;
    }

    public PrimingJob withPrimingManifestUrl(String primingManifestUrl) {
        this.primingManifestUrl = primingManifestUrl;
        return this;
    }

    public String primingJobId() {
        return this.primingJobId;
    }

    public PrimingJobState primingJobState() {
        return this.primingJobState;
    }

    public String primingJobStatus() {
        return this.primingJobStatus;
    }

    public String primingJobDetails() {
        return this.primingJobDetails;
    }

    public Double primingJobPercentComplete() {
        return this.primingJobPercentComplete;
    }

    public void validate() {
        if (this.primingJobName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property primingJobName in model PrimingJob"));
        }
        if (this.primingManifestUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property primingManifestUrl in model PrimingJob"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primingJobName", this.primingJobName);
        jsonWriter.writeStringField("primingManifestUrl", this.primingManifestUrl);
        return jsonWriter.writeEndObject();
    }

    public static PrimingJob fromJson(JsonReader jsonReader) throws IOException {
        return (PrimingJob)jsonReader.readObject(reader -> {
            PrimingJob deserializedPrimingJob = new PrimingJob();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("primingJobName".equals(fieldName)) {
                    deserializedPrimingJob.primingJobName = reader.getString();
                    continue;
                }
                if ("primingManifestUrl".equals(fieldName)) {
                    deserializedPrimingJob.primingManifestUrl = reader.getString();
                    continue;
                }
                if ("primingJobId".equals(fieldName)) {
                    deserializedPrimingJob.primingJobId = reader.getString();
                    continue;
                }
                if ("primingJobState".equals(fieldName)) {
                    deserializedPrimingJob.primingJobState = PrimingJobState.fromString(reader.getString());
                    continue;
                }
                if ("primingJobStatus".equals(fieldName)) {
                    deserializedPrimingJob.primingJobStatus = reader.getString();
                    continue;
                }
                if ("primingJobDetails".equals(fieldName)) {
                    deserializedPrimingJob.primingJobDetails = reader.getString();
                    continue;
                }
                if ("primingJobPercentComplete".equals(fieldName)) {
                    deserializedPrimingJob.primingJobPercentComplete = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrimingJob;
        });
    }
}

