/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.NfsAccessRule;
import java.io.IOException;
import java.util.List;

public final class NfsAccessPolicy
implements JsonSerializable<NfsAccessPolicy> {
    private String name;
    private List<NfsAccessRule> accessRules;
    private static final ClientLogger LOGGER = new ClientLogger(NfsAccessPolicy.class);

    public String name() {
        return this.name;
    }

    public NfsAccessPolicy withName(String name) {
        this.name = name;
        return this;
    }

    public List<NfsAccessRule> accessRules() {
        return this.accessRules;
    }

    public NfsAccessPolicy withAccessRules(List<NfsAccessRule> accessRules) {
        this.accessRules = accessRules;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model NfsAccessPolicy"));
        }
        if (this.accessRules() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accessRules in model NfsAccessPolicy"));
        }
        this.accessRules().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("accessRules", this.accessRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NfsAccessPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (NfsAccessPolicy)jsonReader.readObject(reader -> {
            NfsAccessPolicy deserializedNfsAccessPolicy = new NfsAccessPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNfsAccessPolicy.name = reader.getString();
                    continue;
                }
                if ("accessRules".equals(fieldName)) {
                    List accessRules;
                    deserializedNfsAccessPolicy.accessRules = accessRules = reader.readArray(reader1 -> NfsAccessRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNfsAccessPolicy;
        });
    }
}

