/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.MetricAggregationType;
import com.azure.resourcemanager.storagecache.models.MetricDimension;
import java.io.IOException;
import java.util.List;

public final class MetricSpecification
implements JsonSerializable<MetricSpecification> {
    private String name;
    private String displayName;
    private String displayDescription;
    private String unit;
    private String aggregationType;
    private List<MetricAggregationType> supportedAggregationTypes;
    private String metricClass;
    private List<MetricDimension> dimensions;

    public String name() {
        return this.name;
    }

    public MetricSpecification withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MetricSpecification withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String displayDescription() {
        return this.displayDescription;
    }

    public MetricSpecification withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public MetricSpecification withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String aggregationType() {
        return this.aggregationType;
    }

    public MetricSpecification withAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public List<MetricAggregationType> supportedAggregationTypes() {
        return this.supportedAggregationTypes;
    }

    public MetricSpecification withSupportedAggregationTypes(List<MetricAggregationType> supportedAggregationTypes) {
        this.supportedAggregationTypes = supportedAggregationTypes;
        return this;
    }

    public String metricClass() {
        return this.metricClass;
    }

    public MetricSpecification withMetricClass(String metricClass) {
        this.metricClass = metricClass;
        return this;
    }

    public List<MetricDimension> dimensions() {
        return this.dimensions;
    }

    public MetricSpecification withDimensions(List<MetricDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public void validate() {
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeArrayField("supportedAggregationTypes", this.supportedAggregationTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("metricClass", this.metricClass);
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MetricSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (MetricSpecification)jsonReader.readObject(reader -> {
            MetricSpecification deserializedMetricSpecification = new MetricSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricSpecification.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMetricSpecification.displayName = reader.getString();
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedMetricSpecification.displayDescription = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricSpecification.unit = reader.getString();
                    continue;
                }
                if ("aggregationType".equals(fieldName)) {
                    deserializedMetricSpecification.aggregationType = reader.getString();
                    continue;
                }
                if ("supportedAggregationTypes".equals(fieldName)) {
                    List supportedAggregationTypes;
                    deserializedMetricSpecification.supportedAggregationTypes = supportedAggregationTypes = reader.readArray(reader1 -> MetricAggregationType.fromString(reader1.getString()));
                    continue;
                }
                if ("metricClass".equals(fieldName)) {
                    deserializedMetricSpecification.metricClass = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedMetricSpecification.dimensions = dimensions = reader.readArray(reader1 -> MetricDimension.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricSpecification;
        });
    }
}

