/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.CacheInner;
import java.io.IOException;
import java.util.List;

public final class CachesListResult
implements JsonSerializable<CachesListResult> {
    private String nextLink;
    private List<CacheInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public CachesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<CacheInner> value() {
        return this.value;
    }

    public CachesListResult withValue(List<CacheInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CachesListResult fromJson(JsonReader jsonReader) throws IOException {
        return (CachesListResult)jsonReader.readObject(reader -> {
            CachesListResult deserializedCachesListResult = new CachesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedCachesListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCachesListResult.value = value = reader.readArray(reader1 -> CacheInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCachesListResult;
        });
    }
}

