/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CacheNetworkSettings
implements JsonSerializable<CacheNetworkSettings> {
    private Integer mtu;
    private List<String> utilityAddresses;
    private List<String> dnsServers;
    private String dnsSearchDomain;
    private String ntpServer;

    public Integer mtu() {
        return this.mtu;
    }

    public CacheNetworkSettings withMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    public List<String> utilityAddresses() {
        return this.utilityAddresses;
    }

    public List<String> dnsServers() {
        return this.dnsServers;
    }

    public CacheNetworkSettings withDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
        return this;
    }

    public String dnsSearchDomain() {
        return this.dnsSearchDomain;
    }

    public CacheNetworkSettings withDnsSearchDomain(String dnsSearchDomain) {
        this.dnsSearchDomain = dnsSearchDomain;
        return this;
    }

    public String ntpServer() {
        return this.ntpServer;
    }

    public CacheNetworkSettings withNtpServer(String ntpServer) {
        this.ntpServer = ntpServer;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("mtu", (Number)this.mtu);
        jsonWriter.writeArrayField("dnsServers", this.dnsServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("dnsSearchDomain", this.dnsSearchDomain);
        jsonWriter.writeStringField("ntpServer", this.ntpServer);
        return jsonWriter.writeEndObject();
    }

    public static CacheNetworkSettings fromJson(JsonReader jsonReader) throws IOException {
        return (CacheNetworkSettings)jsonReader.readObject(reader -> {
            CacheNetworkSettings deserializedCacheNetworkSettings = new CacheNetworkSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mtu".equals(fieldName)) {
                    deserializedCacheNetworkSettings.mtu = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("utilityAddresses".equals(fieldName)) {
                    List utilityAddresses;
                    deserializedCacheNetworkSettings.utilityAddresses = utilityAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dnsServers".equals(fieldName)) {
                    List dnsServers;
                    deserializedCacheNetworkSettings.dnsServers = dnsServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dnsSearchDomain".equals(fieldName)) {
                    deserializedCacheNetworkSettings.dnsSearchDomain = reader.getString();
                    continue;
                }
                if ("ntpServer".equals(fieldName)) {
                    deserializedCacheNetworkSettings.ntpServer = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheNetworkSettings;
        });
    }
}

