/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.CacheIdentityType;
import com.azure.resourcemanager.storagecache.models.UserAssignedIdentitiesValueAutoGenerated;
import java.io.IOException;
import java.util.Map;

public final class CacheIdentity
implements JsonSerializable<CacheIdentity> {
    private String principalId;
    private String tenantId;
    private CacheIdentityType type;
    private Map<String, UserAssignedIdentitiesValueAutoGenerated> userAssignedIdentities;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public CacheIdentityType type() {
        return this.type;
    }

    public CacheIdentity withType(CacheIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserAssignedIdentitiesValueAutoGenerated> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public CacheIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentitiesValueAutoGenerated> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CacheIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (CacheIdentity)jsonReader.readObject(reader -> {
            CacheIdentity deserializedCacheIdentity = new CacheIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedCacheIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedCacheIdentity.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCacheIdentity.type = CacheIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedCacheIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserAssignedIdentitiesValueAutoGenerated.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheIdentity;
        });
    }
}

