/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.Condition;
import com.azure.resourcemanager.storagecache.models.HealthStateType;
import java.io.IOException;
import java.util.List;

public final class CacheHealth
implements JsonSerializable<CacheHealth> {
    private HealthStateType state;
    private String statusDescription;
    private List<Condition> conditions;

    public HealthStateType state() {
        return this.state;
    }

    public CacheHealth withState(HealthStateType state) {
        this.state = state;
        return this;
    }

    public String statusDescription() {
        return this.statusDescription;
    }

    public CacheHealth withStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
        return this;
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public void validate() {
        if (this.conditions() != null) {
            this.conditions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("statusDescription", this.statusDescription);
        return jsonWriter.writeEndObject();
    }

    public static CacheHealth fromJson(JsonReader jsonReader) throws IOException {
        return (CacheHealth)jsonReader.readObject(reader -> {
            CacheHealth deserializedCacheHealth = new CacheHealth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedCacheHealth.state = HealthStateType.fromString(reader.getString());
                    continue;
                }
                if ("statusDescription".equals(fieldName)) {
                    deserializedCacheHealth.statusDescription = reader.getString();
                    continue;
                }
                if ("conditions".equals(fieldName)) {
                    List conditions;
                    deserializedCacheHealth.conditions = conditions = reader.readArray(reader1 -> Condition.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheHealth;
        });
    }
}

