/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.CacheActiveDirectorySettings;
import com.azure.resourcemanager.storagecache.models.CacheUsernameDownloadSettings;
import java.io.IOException;

public final class CacheDirectorySettings
implements JsonSerializable<CacheDirectorySettings> {
    private CacheActiveDirectorySettings activeDirectory;
    private CacheUsernameDownloadSettings usernameDownload;

    public CacheActiveDirectorySettings activeDirectory() {
        return this.activeDirectory;
    }

    public CacheDirectorySettings withActiveDirectory(CacheActiveDirectorySettings activeDirectory) {
        this.activeDirectory = activeDirectory;
        return this;
    }

    public CacheUsernameDownloadSettings usernameDownload() {
        return this.usernameDownload;
    }

    public CacheDirectorySettings withUsernameDownload(CacheUsernameDownloadSettings usernameDownload) {
        this.usernameDownload = usernameDownload;
        return this;
    }

    public void validate() {
        if (this.activeDirectory() != null) {
            this.activeDirectory().validate();
        }
        if (this.usernameDownload() != null) {
            this.usernameDownload().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("activeDirectory", (JsonSerializable)this.activeDirectory);
        jsonWriter.writeJsonField("usernameDownload", (JsonSerializable)this.usernameDownload);
        return jsonWriter.writeEndObject();
    }

    public static CacheDirectorySettings fromJson(JsonReader jsonReader) throws IOException {
        return (CacheDirectorySettings)jsonReader.readObject(reader -> {
            CacheDirectorySettings deserializedCacheDirectorySettings = new CacheDirectorySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("activeDirectory".equals(fieldName)) {
                    deserializedCacheDirectorySettings.activeDirectory = CacheActiveDirectorySettings.fromJson(reader);
                    continue;
                }
                if ("usernameDownload".equals(fieldName)) {
                    deserializedCacheDirectorySettings.usernameDownload = CacheUsernameDownloadSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheDirectorySettings;
        });
    }
}

