/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CacheActiveDirectorySettingsCredentials
implements JsonSerializable<CacheActiveDirectorySettingsCredentials> {
    private String username;
    private String password;
    private static final ClientLogger LOGGER = new ClientLogger(CacheActiveDirectorySettingsCredentials.class);

    public String username() {
        return this.username;
    }

    public CacheActiveDirectorySettingsCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public CacheActiveDirectorySettingsCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model CacheActiveDirectorySettingsCredentials"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static CacheActiveDirectorySettingsCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (CacheActiveDirectorySettingsCredentials)jsonReader.readObject(reader -> {
            CacheActiveDirectorySettingsCredentials deserializedCacheActiveDirectorySettingsCredentials = new CacheActiveDirectorySettingsCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettingsCredentials.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCacheActiveDirectorySettingsCredentials.password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheActiveDirectorySettingsCredentials;
        });
    }
}

