/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AutoImportJobUpdateProperties;
import com.azure.resourcemanager.storagecache.models.AutoImportJobUpdatePropertiesAdminStatus;
import java.io.IOException;
import java.util.Map;

public final class AutoImportJobUpdate
implements JsonSerializable<AutoImportJobUpdate> {
    private Map<String, String> tags;
    private AutoImportJobUpdateProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public AutoImportJobUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private AutoImportJobUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public AutoImportJobUpdatePropertiesAdminStatus adminStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().adminStatus();
    }

    public AutoImportJobUpdate withAdminStatus(AutoImportJobUpdatePropertiesAdminStatus adminStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoImportJobUpdateProperties();
        }
        this.innerProperties().withAdminStatus(adminStatus);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AutoImportJobUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (AutoImportJobUpdate)jsonReader.readObject(reader -> {
            AutoImportJobUpdate deserializedAutoImportJobUpdate = new AutoImportJobUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedAutoImportJobUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAutoImportJobUpdate.innerProperties = AutoImportJobUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoImportJobUpdate;
        });
    }
}

