/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.fluent.models.AutoImportJobInner;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesAdminStatus;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesProvisioningState;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesStatusBlobSyncEvents;
import com.azure.resourcemanager.storagecache.models.AutoImportJobState;
import com.azure.resourcemanager.storagecache.models.AutoImportJobUpdatePropertiesAdminStatus;
import com.azure.resourcemanager.storagecache.models.ConflictResolutionMode;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface AutoImportJob {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public AutoImportJobPropertiesProvisioningState provisioningState();

    public AutoImportJobPropertiesAdminStatus adminStatus();

    public List<String> autoImportPrefixes();

    public ConflictResolutionMode conflictResolutionMode();

    public Boolean enableDeletions();

    public Long maximumErrors();

    public AutoImportJobState state();

    public String statusCode();

    public String statusMessage();

    public OffsetDateTime scanStartTime();

    public OffsetDateTime scanEndTime();

    public Long totalBlobsWalked();

    public Long rateOfBlobWalk();

    public Long totalBlobsImported();

    public Long rateOfBlobImport();

    public Long importedFiles();

    public Long importedDirectories();

    public Long importedSymlinks();

    public Long preexistingFiles();

    public Long preexistingDirectories();

    public Long preexistingSymlinks();

    public Long totalErrors();

    public Long totalConflicts();

    public AutoImportJobPropertiesStatusBlobSyncEvents blobSyncEvents();

    public OffsetDateTime lastStartedTimeUtc();

    public OffsetDateTime lastCompletionTimeUtc();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public AutoImportJobInner innerModel();

    public Update update();

    public AutoImportJob refresh();

    public AutoImportJob refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithAdminStatus {
            public Update withAdminStatus(AutoImportJobUpdatePropertiesAdminStatus var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithAdminStatus {
        public AutoImportJob apply();

        public AutoImportJob apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMaximumErrors {
            public WithCreate withMaximumErrors(Long var1);
        }

        public static interface WithEnableDeletions {
            public WithCreate withEnableDeletions(Boolean var1);
        }

        public static interface WithConflictResolutionMode {
            public WithCreate withConflictResolutionMode(ConflictResolutionMode var1);
        }

        public static interface WithAutoImportPrefixes {
            public WithCreate withAutoImportPrefixes(List<String> var1);
        }

        public static interface WithAdminStatus {
            public WithCreate withAdminStatus(AutoImportJobPropertiesAdminStatus var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithAdminStatus,
        WithAutoImportPrefixes,
        WithConflictResolutionMode,
        WithEnableDeletions,
        WithMaximumErrors {
            public AutoImportJob create();

            public AutoImportJob create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAmlFilesystem(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

