/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AutoExportJobInner;
import java.io.IOException;
import java.util.List;

public final class AutoExportJobsListResult
implements JsonSerializable<AutoExportJobsListResult> {
    private String nextLink;
    private List<AutoExportJobInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public AutoExportJobsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<AutoExportJobInner> value() {
        return this.value;
    }

    public AutoExportJobsListResult withValue(List<AutoExportJobInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AutoExportJobsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (AutoExportJobsListResult)jsonReader.readObject(reader -> {
            AutoExportJobsListResult deserializedAutoExportJobsListResult = new AutoExportJobsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedAutoExportJobsListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAutoExportJobsListResult.value = value = reader.readArray(reader1 -> AutoExportJobInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoExportJobsListResult;
        });
    }
}

