/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AutoExportJobUpdateProperties;
import com.azure.resourcemanager.storagecache.models.AutoExportJobAdminStatus;
import java.io.IOException;
import java.util.Map;

public final class AutoExportJobUpdate
implements JsonSerializable<AutoExportJobUpdate> {
    private Map<String, String> tags;
    private AutoExportJobUpdateProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public AutoExportJobUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private AutoExportJobUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public AutoExportJobAdminStatus adminStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().adminStatus();
    }

    public AutoExportJobUpdate withAdminStatus(AutoExportJobAdminStatus adminStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoExportJobUpdateProperties();
        }
        this.innerProperties().withAdminStatus(adminStatus);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AutoExportJobUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (AutoExportJobUpdate)jsonReader.readObject(reader -> {
            AutoExportJobUpdate deserializedAutoExportJobUpdate = new AutoExportJobUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedAutoExportJobUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAutoExportJobUpdate.innerProperties = AutoExportJobUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoExportJobUpdate;
        });
    }
}

