/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.fluent.models.AutoExportJobInner;
import com.azure.resourcemanager.storagecache.models.AutoExportJobAdminStatus;
import com.azure.resourcemanager.storagecache.models.AutoExportJobProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.AutoExportStatusType;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface AutoExportJob {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public AutoExportJobProvisioningStateType provisioningState();

    public AutoExportJobAdminStatus adminStatus();

    public List<String> autoExportPrefixes();

    public AutoExportStatusType state();

    public String statusCode();

    public String statusMessage();

    public Long totalFilesExported();

    public Long totalMiBExported();

    public Long totalFilesFailed();

    public Integer exportIterationCount();

    public OffsetDateTime lastSuccessfulIterationCompletionTimeUtc();

    public Long currentIterationFilesDiscovered();

    public Long currentIterationMiBDiscovered();

    public Long currentIterationFilesExported();

    public Long currentIterationMiBExported();

    public Long currentIterationFilesFailed();

    public OffsetDateTime lastStartedTimeUtc();

    public OffsetDateTime lastCompletionTimeUtc();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public AutoExportJobInner innerModel();

    public Update update();

    public AutoExportJob refresh();

    public AutoExportJob refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithAdminStatus {
            public Update withAdminStatus(AutoExportJobAdminStatus var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithAdminStatus {
        public AutoExportJob apply();

        public AutoExportJob apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithAutoExportPrefixes {
            public WithCreate withAutoExportPrefixes(List<String> var1);
        }

        public static interface WithAdminStatus {
            public WithCreate withAdminStatus(AutoExportJobAdminStatus var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithAdminStatus,
        WithAutoExportPrefixes {
            public AutoExportJob create();

            public AutoExportJob create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAmlFilesystem(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

