/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.ApiOperationInner;
import java.io.IOException;
import java.util.List;

public final class ApiOperationListResult
implements JsonSerializable<ApiOperationListResult> {
    private String nextLink;
    private List<ApiOperationInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ApiOperationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ApiOperationInner> value() {
        return this.value;
    }

    public ApiOperationListResult withValue(List<ApiOperationInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApiOperationListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ApiOperationListResult)jsonReader.readObject(reader -> {
            ApiOperationListResult deserializedApiOperationListResult = new ApiOperationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedApiOperationListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedApiOperationListResult.value = value = reader.readArray(reader1 -> ApiOperationInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiOperationListResult;
        });
    }
}

