/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AmlFilesystemUpdateProperties;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemRootSquashSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemUpdatePropertiesMaintenanceWindow;
import java.io.IOException;
import java.util.Map;

public final class AmlFilesystemUpdate
implements JsonSerializable<AmlFilesystemUpdate> {
    private Map<String, String> tags;
    private AmlFilesystemUpdateProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public AmlFilesystemUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private AmlFilesystemUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public AmlFilesystemEncryptionSettings encryptionSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionSettings();
    }

    public AmlFilesystemUpdate withEncryptionSettings(AmlFilesystemEncryptionSettings encryptionSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemUpdateProperties();
        }
        this.innerProperties().withEncryptionSettings(encryptionSettings);
        return this;
    }

    public AmlFilesystemUpdatePropertiesMaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    public AmlFilesystemUpdate withMaintenanceWindow(AmlFilesystemUpdatePropertiesMaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemUpdateProperties();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public AmlFilesystemRootSquashSettings rootSquashSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().rootSquashSettings();
    }

    public AmlFilesystemUpdate withRootSquashSettings(AmlFilesystemRootSquashSettings rootSquashSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AmlFilesystemUpdateProperties();
        }
        this.innerProperties().withRootSquashSettings(rootSquashSettings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AmlFilesystemUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (AmlFilesystemUpdate)jsonReader.readObject(reader -> {
            AmlFilesystemUpdate deserializedAmlFilesystemUpdate = new AmlFilesystemUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedAmlFilesystemUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAmlFilesystemUpdate.innerProperties = AmlFilesystemUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmlFilesystemUpdate;
        });
    }
}

