/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.SkuName;
import java.io.IOException;

public final class AmlFilesystemSubnetInfo
implements JsonSerializable<AmlFilesystemSubnetInfo> {
    private String filesystemSubnet;
    private Float storageCapacityTiB;
    private SkuName sku;
    private String location;

    public String filesystemSubnet() {
        return this.filesystemSubnet;
    }

    public AmlFilesystemSubnetInfo withFilesystemSubnet(String filesystemSubnet) {
        this.filesystemSubnet = filesystemSubnet;
        return this;
    }

    public Float storageCapacityTiB() {
        return this.storageCapacityTiB;
    }

    public AmlFilesystemSubnetInfo withStorageCapacityTiB(Float storageCapacityTiB) {
        this.storageCapacityTiB = storageCapacityTiB;
        return this;
    }

    public SkuName sku() {
        return this.sku;
    }

    public AmlFilesystemSubnetInfo withSku(SkuName sku) {
        this.sku = sku;
        return this;
    }

    public String location() {
        return this.location;
    }

    public AmlFilesystemSubnetInfo withLocation(String location) {
        this.location = location;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filesystemSubnet", this.filesystemSubnet);
        jsonWriter.writeNumberField("storageCapacityTiB", (Number)this.storageCapacityTiB);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static AmlFilesystemSubnetInfo fromJson(JsonReader jsonReader) throws IOException {
        return (AmlFilesystemSubnetInfo)jsonReader.readObject(reader -> {
            AmlFilesystemSubnetInfo deserializedAmlFilesystemSubnetInfo = new AmlFilesystemSubnetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filesystemSubnet".equals(fieldName)) {
                    deserializedAmlFilesystemSubnetInfo.filesystemSubnet = reader.getString();
                    continue;
                }
                if ("storageCapacityTiB".equals(fieldName)) {
                    deserializedAmlFilesystemSubnetInfo.storageCapacityTiB = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedAmlFilesystemSubnetInfo.sku = SkuName.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAmlFilesystemSubnetInfo.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmlFilesystemSubnetInfo;
        });
    }
}

