/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.ArchiveStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class AmlFilesystemArchiveStatus
implements JsonSerializable<AmlFilesystemArchiveStatus> {
    private ArchiveStatusType state;
    private OffsetDateTime lastCompletionTime;
    private OffsetDateTime lastStartedTime;
    private Integer percentComplete;
    private String errorCode;
    private String errorMessage;

    public ArchiveStatusType state() {
        return this.state;
    }

    public OffsetDateTime lastCompletionTime() {
        return this.lastCompletionTime;
    }

    public OffsetDateTime lastStartedTime() {
        return this.lastStartedTime;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static AmlFilesystemArchiveStatus fromJson(JsonReader jsonReader) throws IOException {
        return (AmlFilesystemArchiveStatus)jsonReader.readObject(reader -> {
            AmlFilesystemArchiveStatus deserializedAmlFilesystemArchiveStatus = new AmlFilesystemArchiveStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedAmlFilesystemArchiveStatus.state = ArchiveStatusType.fromString(reader.getString());
                    continue;
                }
                if ("lastCompletionTime".equals(fieldName)) {
                    deserializedAmlFilesystemArchiveStatus.lastCompletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastStartedTime".equals(fieldName)) {
                    deserializedAmlFilesystemArchiveStatus.lastStartedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedAmlFilesystemArchiveStatus.percentComplete = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedAmlFilesystemArchiveStatus.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedAmlFilesystemArchiveStatus.errorMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmlFilesystemArchiveStatus;
        });
    }
}

