/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.UsageModelsClient;
import com.azure.resourcemanager.storagecache.fluent.models.UsageModelInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.implementation.UsageModelImpl;
import com.azure.resourcemanager.storagecache.models.UsageModel;
import com.azure.resourcemanager.storagecache.models.UsageModels;

public final class UsageModelsImpl
implements UsageModels {
    private static final ClientLogger LOGGER = new ClientLogger(UsageModelsImpl.class);
    private final UsageModelsClient innerClient;
    private final StorageCacheManager serviceManager;

    public UsageModelsImpl(UsageModelsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<UsageModel> list() {
        PagedIterable<UsageModelInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageModelImpl((UsageModelInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<UsageModel> list(Context context) {
        PagedIterable<UsageModelInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageModelImpl((UsageModelInner)inner1, this.manager()));
    }

    private UsageModelsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }
}

