/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.StorageTargetsClient;
import com.azure.resourcemanager.storagecache.fluent.models.StorageTargetInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.implementation.StorageTargetImpl;
import com.azure.resourcemanager.storagecache.models.StorageTarget;
import com.azure.resourcemanager.storagecache.models.StorageTargets;

public final class StorageTargetsImpl
implements StorageTargets {
    private static final ClientLogger LOGGER = new ClientLogger(StorageTargetsImpl.class);
    private final StorageTargetsClient innerClient;
    private final StorageCacheManager serviceManager;

    public StorageTargetsImpl(StorageTargetsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void dnsRefresh(String resourceGroupName, String cacheName, String storageTargetName) {
        this.serviceClient().dnsRefresh(resourceGroupName, cacheName, storageTargetName);
    }

    @Override
    public void dnsRefresh(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.serviceClient().dnsRefresh(resourceGroupName, cacheName, storageTargetName, context);
    }

    @Override
    public PagedIterable<StorageTarget> listByCache(String resourceGroupName, String cacheName) {
        PagedIterable<StorageTargetInner> inner = this.serviceClient().listByCache(resourceGroupName, cacheName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTargetImpl((StorageTargetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageTarget> listByCache(String resourceGroupName, String cacheName, Context context) {
        PagedIterable<StorageTargetInner> inner = this.serviceClient().listByCache(resourceGroupName, cacheName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTargetImpl((StorageTargetInner)((Object)inner1), this.manager()));
    }

    @Override
    public void delete(String resourceGroupName, String cacheName, String storageTargetName) {
        this.serviceClient().delete(resourceGroupName, cacheName, storageTargetName);
    }

    @Override
    public void delete(String resourceGroupName, String cacheName, String storageTargetName, String force, Context context) {
        this.serviceClient().delete(resourceGroupName, cacheName, storageTargetName, force, context);
    }

    @Override
    public Response<StorageTarget> getWithResponse(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        Response<StorageTargetInner> inner = this.serviceClient().getWithResponse(resourceGroupName, cacheName, storageTargetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new StorageTargetImpl((StorageTargetInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public StorageTarget get(String resourceGroupName, String cacheName, String storageTargetName) {
        StorageTargetInner inner = this.serviceClient().get(resourceGroupName, cacheName, storageTargetName);
        if (inner != null) {
            return new StorageTargetImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void restoreDefaults(String resourceGroupName, String cacheName, String storageTargetName) {
        this.serviceClient().restoreDefaults(resourceGroupName, cacheName, storageTargetName);
    }

    @Override
    public void restoreDefaults(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.serviceClient().restoreDefaults(resourceGroupName, cacheName, storageTargetName, context);
    }

    @Override
    public StorageTarget getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        String storageTargetName = ResourceManagerUtils.getValueFromIdByName(id, "storageTargets");
        if (storageTargetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageTargets'.", id)));
        }
        return (StorageTarget)this.getWithResponse(resourceGroupName, cacheName, storageTargetName, Context.NONE).getValue();
    }

    @Override
    public Response<StorageTarget> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        String storageTargetName = ResourceManagerUtils.getValueFromIdByName(id, "storageTargets");
        if (storageTargetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageTargets'.", id)));
        }
        return this.getWithResponse(resourceGroupName, cacheName, storageTargetName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        String storageTargetName = ResourceManagerUtils.getValueFromIdByName(id, "storageTargets");
        if (storageTargetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageTargets'.", id)));
        }
        String localForce = null;
        this.delete(resourceGroupName, cacheName, storageTargetName, localForce, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String force, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String cacheName = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        String storageTargetName = ResourceManagerUtils.getValueFromIdByName(id, "storageTargets");
        if (storageTargetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageTargets'.", id)));
        }
        this.delete(resourceGroupName, cacheName, storageTargetName, force, context);
    }

    private StorageTargetsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageTargetImpl define(String name) {
        return new StorageTargetImpl(name, this.manager());
    }
}

