/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storagecache.fluent.StorageTargetOperationsClient;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class StorageTargetOperationsClientImpl
implements StorageTargetOperationsClient {
    private final StorageTargetOperationsService service;
    private final StorageCacheManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTargetOperationsClientImpl.class);

    StorageTargetOperationsClientImpl(StorageCacheManagementClientImpl client) {
        this.service = (StorageTargetOperationsService)RestProxy.create(StorageTargetOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> flushWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.flush(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> flushWithResponse(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.flushSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> flushWithResponse(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.flushSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginFlushAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.flushWithResponseAsync(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginFlush(String resourceGroupName, String cacheName, String storageTargetName) {
        Response<BinaryData> response = this.flushWithResponse(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginFlush(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        Response<BinaryData> response = this.flushWithResponse(resourceGroupName, cacheName, storageTargetName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> flushAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        return this.beginFlushAsync(resourceGroupName, cacheName, storageTargetName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void flush(String resourceGroupName, String cacheName, String storageTargetName) {
        this.beginFlush(resourceGroupName, cacheName, storageTargetName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void flush(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.beginFlush(resourceGroupName, cacheName, storageTargetName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> suspendWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.suspend(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> suspendWithResponse(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.suspendSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> suspendWithResponse(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.suspendSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginSuspendAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.suspendWithResponseAsync(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginSuspend(String resourceGroupName, String cacheName, String storageTargetName) {
        Response<BinaryData> response = this.suspendWithResponse(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginSuspend(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        Response<BinaryData> response = this.suspendWithResponse(resourceGroupName, cacheName, storageTargetName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> suspendAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        return this.beginSuspendAsync(resourceGroupName, cacheName, storageTargetName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void suspend(String resourceGroupName, String cacheName, String storageTargetName) {
        this.beginSuspend(resourceGroupName, cacheName, storageTargetName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void suspend(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.beginSuspend(resourceGroupName, cacheName, storageTargetName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> resumeWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resume(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> resumeWithResponse(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.resumeSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> resumeWithResponse(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.resumeSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginResumeAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.resumeWithResponseAsync(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginResume(String resourceGroupName, String cacheName, String storageTargetName) {
        Response<BinaryData> response = this.resumeWithResponse(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginResume(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        Response<BinaryData> response = this.resumeWithResponse(resourceGroupName, cacheName, storageTargetName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> resumeAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        return this.beginResumeAsync(resourceGroupName, cacheName, storageTargetName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resume(String resourceGroupName, String cacheName, String storageTargetName) {
        this.beginResume(resourceGroupName, cacheName, storageTargetName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resume(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.beginResume(resourceGroupName, cacheName, storageTargetName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> invalidateWithResponseAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.invalidate(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> invalidateWithResponse(String resourceGroupName, String cacheName, String storageTargetName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.invalidateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> invalidateWithResponse(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (cacheName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (storageTargetName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter storageTargetName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.invalidateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), cacheName, storageTargetName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginInvalidateAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.invalidateWithResponseAsync(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginInvalidate(String resourceGroupName, String cacheName, String storageTargetName) {
        Response<BinaryData> response = this.invalidateWithResponse(resourceGroupName, cacheName, storageTargetName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginInvalidate(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        Response<BinaryData> response = this.invalidateWithResponse(resourceGroupName, cacheName, storageTargetName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> invalidateAsync(String resourceGroupName, String cacheName, String storageTargetName) {
        return this.beginInvalidateAsync(resourceGroupName, cacheName, storageTargetName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void invalidate(String resourceGroupName, String cacheName, String storageTargetName) {
        this.beginInvalidate(resourceGroupName, cacheName, storageTargetName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void invalidate(String resourceGroupName, String cacheName, String storageTargetName, Context context) {
        this.beginInvalidate(resourceGroupName, cacheName, storageTargetName, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageCacheManagementClientStorageTargetOperations")
    public static interface StorageTargetOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/flush")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> flush(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/flush")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> flushSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/suspend")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> suspend(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/suspend")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> suspendSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/resume")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> resume(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/resume")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> resumeSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/invalidate")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> invalidate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}/storageTargets/{storageTargetName}/invalidate")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> invalidateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="cacheName") String var5, @PathParam(value="storageTargetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

