/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.storagecache.fluent.models.RequiredAmlFilesystemSubnetsSizeInner;
import com.azure.resourcemanager.storagecache.implementation.RequiredAmlFilesystemSubnetsSizeImpl;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemSubnetInfo;
import com.azure.resourcemanager.storagecache.models.RequiredAmlFilesystemSubnetsSize;
import com.azure.resourcemanager.storagecache.models.RequiredAmlFilesystemSubnetsSizeInfo;
import com.azure.resourcemanager.storagecache.models.ResourceProviders;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final StorageCacheManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> checkAmlFSSubnetsWithResponse(AmlFilesystemSubnetInfo amlFilesystemSubnetInfo, Context context) {
        return this.serviceClient().checkAmlFSSubnetsWithResponse(amlFilesystemSubnetInfo, context);
    }

    @Override
    public void checkAmlFSSubnets() {
        this.serviceClient().checkAmlFSSubnets();
    }

    @Override
    public Response<RequiredAmlFilesystemSubnetsSize> getRequiredAmlFSSubnetsSizeWithResponse(RequiredAmlFilesystemSubnetsSizeInfo requiredAmlFilesystemSubnetsSizeInfo, Context context) {
        Response<RequiredAmlFilesystemSubnetsSizeInner> inner = this.serviceClient().getRequiredAmlFSSubnetsSizeWithResponse(requiredAmlFilesystemSubnetsSizeInfo, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RequiredAmlFilesystemSubnetsSizeImpl((RequiredAmlFilesystemSubnetsSizeInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RequiredAmlFilesystemSubnetsSize getRequiredAmlFSSubnetsSize() {
        RequiredAmlFilesystemSubnetsSizeInner inner = this.serviceClient().getRequiredAmlFSSubnetsSize();
        if (inner != null) {
            return new RequiredAmlFilesystemSubnetsSizeImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }
}

