/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storagecache.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.storagecache.fluent.models.RequiredAmlFilesystemSubnetsSizeInner;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientImpl;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemCheckSubnetErrorException;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemSubnetInfo;
import com.azure.resourcemanager.storagecache.models.RequiredAmlFilesystemSubnetsSizeInfo;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final StorageCacheManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersClientImpl.class);

    ResourceProvidersClientImpl(StorageCacheManagementClientImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> checkAmlFSSubnetsWithResponseAsync(AmlFilesystemSubnetInfo amlFilesystemSubnetInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemSubnetInfo != null) {
            amlFilesystemSubnetInfo.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkAmlFSSubnets(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemSubnetInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> checkAmlFSSubnetsAsync() {
        AmlFilesystemSubnetInfo amlFilesystemSubnetInfo = null;
        return this.checkAmlFSSubnetsWithResponseAsync(amlFilesystemSubnetInfo).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> checkAmlFSSubnetsWithResponse(AmlFilesystemSubnetInfo amlFilesystemSubnetInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemSubnetInfo != null) {
            amlFilesystemSubnetInfo.validate();
        }
        String accept = "application/json";
        return this.service.checkAmlFSSubnetsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemSubnetInfo, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkAmlFSSubnets() {
        AmlFilesystemSubnetInfo amlFilesystemSubnetInfo = null;
        this.checkAmlFSSubnetsWithResponse(amlFilesystemSubnetInfo, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RequiredAmlFilesystemSubnetsSizeInner>> getRequiredAmlFSSubnetsSizeWithResponseAsync(RequiredAmlFilesystemSubnetsSizeInfo requiredAmlFilesystemSubnetsSizeInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (requiredAmlFilesystemSubnetsSizeInfo != null) {
            requiredAmlFilesystemSubnetsSizeInfo.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRequiredAmlFSSubnetsSize(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), requiredAmlFilesystemSubnetsSizeInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RequiredAmlFilesystemSubnetsSizeInner> getRequiredAmlFSSubnetsSizeAsync() {
        RequiredAmlFilesystemSubnetsSizeInfo requiredAmlFilesystemSubnetsSizeInfo = null;
        return this.getRequiredAmlFSSubnetsSizeWithResponseAsync(requiredAmlFilesystemSubnetsSizeInfo).flatMap(res -> Mono.justOrEmpty((Object)((RequiredAmlFilesystemSubnetsSizeInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RequiredAmlFilesystemSubnetsSizeInner> getRequiredAmlFSSubnetsSizeWithResponse(RequiredAmlFilesystemSubnetsSizeInfo requiredAmlFilesystemSubnetsSizeInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (requiredAmlFilesystemSubnetsSizeInfo != null) {
            requiredAmlFilesystemSubnetsSizeInfo.validate();
        }
        String accept = "application/json";
        return this.service.getRequiredAmlFSSubnetsSizeSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), requiredAmlFilesystemSubnetsSizeInfo, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RequiredAmlFilesystemSubnetsSizeInner getRequiredAmlFSSubnetsSize() {
        RequiredAmlFilesystemSubnetsSizeInfo requiredAmlFilesystemSubnetsSizeInfo = null;
        return (RequiredAmlFilesystemSubnetsSizeInner)this.getRequiredAmlFSSubnetsSizeWithResponse(requiredAmlFilesystemSubnetsSizeInfo, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageCacheManagementClientResourceProviders")
    public static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/checkAmlFSSubnets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=AmlFilesystemCheckSubnetErrorException.class, code={400}), @UnexpectedResponseExceptionType(value=ManagementException.class)})
        public Mono<Response<Void>> checkAmlFSSubnets(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") AmlFilesystemSubnetInfo var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/checkAmlFSSubnets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=AmlFilesystemCheckSubnetErrorException.class, code={400}), @UnexpectedResponseExceptionType(value=ManagementException.class)})
        public Response<Void> checkAmlFSSubnetsSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") AmlFilesystemSubnetInfo var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/getRequiredAmlFSSubnetsSize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RequiredAmlFilesystemSubnetsSizeInner>> getRequiredAmlFSSubnetsSize(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") RequiredAmlFilesystemSubnetsSizeInfo var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/getRequiredAmlFSSubnetsSize")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<RequiredAmlFilesystemSubnetsSizeInner> getRequiredAmlFSSubnetsSizeSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") RequiredAmlFilesystemSubnetsSizeInfo var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

