/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.OperationsClient;
import com.azure.resourcemanager.storagecache.fluent.models.ApiOperationInner;
import com.azure.resourcemanager.storagecache.implementation.ApiOperationImpl;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.ApiOperation;
import com.azure.resourcemanager.storagecache.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final StorageCacheManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiOperation> list() {
        PagedIterable<ApiOperationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiOperationImpl((ApiOperationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ApiOperation> list(Context context) {
        PagedIterable<ApiOperationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiOperationImpl((ApiOperationInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }
}

