/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.ImportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.models.ImportJobInner;
import com.azure.resourcemanager.storagecache.implementation.ImportJobImpl;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.ImportJob;
import com.azure.resourcemanager.storagecache.models.ImportJobs;

public final class ImportJobsImpl
implements ImportJobs {
    private static final ClientLogger LOGGER = new ClientLogger(ImportJobsImpl.class);
    private final ImportJobsClient innerClient;
    private final StorageCacheManager serviceManager;

    public ImportJobsImpl(ImportJobsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String amlFilesystemName, String importJobName) {
        this.serviceClient().delete(resourceGroupName, amlFilesystemName, importJobName);
    }

    @Override
    public void delete(String resourceGroupName, String amlFilesystemName, String importJobName, Context context) {
        this.serviceClient().delete(resourceGroupName, amlFilesystemName, importJobName, context);
    }

    @Override
    public Response<ImportJob> getWithResponse(String resourceGroupName, String amlFilesystemName, String importJobName, Context context) {
        Response<ImportJobInner> inner = this.serviceClient().getWithResponse(resourceGroupName, amlFilesystemName, importJobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ImportJobImpl((ImportJobInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ImportJob get(String resourceGroupName, String amlFilesystemName, String importJobName) {
        ImportJobInner inner = this.serviceClient().get(resourceGroupName, amlFilesystemName, importJobName);
        if (inner != null) {
            return new ImportJobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ImportJob> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        PagedIterable<ImportJobInner> inner = this.serviceClient().listByAmlFilesystem(resourceGroupName, amlFilesystemName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ImportJobImpl((ImportJobInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ImportJob> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName, Context context) {
        PagedIterable<ImportJobInner> inner = this.serviceClient().listByAmlFilesystem(resourceGroupName, amlFilesystemName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ImportJobImpl((ImportJobInner)((Object)inner1), this.manager()));
    }

    @Override
    public ImportJob getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String importJobName = ResourceManagerUtils.getValueFromIdByName(id, "importJobs");
        if (importJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'importJobs'.", id)));
        }
        return (ImportJob)this.getWithResponse(resourceGroupName, amlFilesystemName, importJobName, Context.NONE).getValue();
    }

    @Override
    public Response<ImportJob> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String importJobName = ResourceManagerUtils.getValueFromIdByName(id, "importJobs");
        if (importJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'importJobs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, amlFilesystemName, importJobName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String importJobName = ResourceManagerUtils.getValueFromIdByName(id, "importJobs");
        if (importJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'importJobs'.", id)));
        }
        this.delete(resourceGroupName, amlFilesystemName, importJobName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String importJobName = ResourceManagerUtils.getValueFromIdByName(id, "importJobs");
        if (importJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'importJobs'.", id)));
        }
        this.delete(resourceGroupName, amlFilesystemName, importJobName, context);
    }

    private ImportJobsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public ImportJobImpl define(String name) {
        return new ImportJobImpl(name, this.manager());
    }
}

