/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.models.ImportJobInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.ConflictResolutionMode;
import com.azure.resourcemanager.storagecache.models.ImportJob;
import com.azure.resourcemanager.storagecache.models.ImportJobAdminStatus;
import com.azure.resourcemanager.storagecache.models.ImportJobProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.ImportJobUpdate;
import com.azure.resourcemanager.storagecache.models.ImportStatusType;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ImportJobImpl
implements ImportJob,
ImportJob.Definition,
ImportJob.Update {
    private ImportJobInner innerObject;
    private final StorageCacheManager serviceManager;
    private String resourceGroupName;
    private String amlFilesystemName;
    private String importJobName;
    private ImportJobUpdate updateImportJob;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ImportJobProvisioningStateType provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public ImportJobAdminStatus adminStatus() {
        return this.innerModel().adminStatus();
    }

    @Override
    public List<String> importPrefixes() {
        List<String> inner = this.innerModel().importPrefixes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ConflictResolutionMode conflictResolutionMode() {
        return this.innerModel().conflictResolutionMode();
    }

    @Override
    public Integer maximumErrors() {
        return this.innerModel().maximumErrors();
    }

    @Override
    public ImportStatusType state() {
        return this.innerModel().state();
    }

    @Override
    public String statusMessage() {
        return this.innerModel().statusMessage();
    }

    @Override
    public Long totalBlobsWalked() {
        return this.innerModel().totalBlobsWalked();
    }

    @Override
    public Long blobsWalkedPerSecond() {
        return this.innerModel().blobsWalkedPerSecond();
    }

    @Override
    public Long totalBlobsImported() {
        return this.innerModel().totalBlobsImported();
    }

    @Override
    public Long importedFiles() {
        return this.innerModel().importedFiles();
    }

    @Override
    public Long importedDirectories() {
        return this.innerModel().importedDirectories();
    }

    @Override
    public Long importedSymlinks() {
        return this.innerModel().importedSymlinks();
    }

    @Override
    public Long preexistingFiles() {
        return this.innerModel().preexistingFiles();
    }

    @Override
    public Long preexistingDirectories() {
        return this.innerModel().preexistingDirectories();
    }

    @Override
    public Long preexistingSymlinks() {
        return this.innerModel().preexistingSymlinks();
    }

    @Override
    public Long blobsImportedPerSecond() {
        return this.innerModel().blobsImportedPerSecond();
    }

    @Override
    public OffsetDateTime lastCompletionTime() {
        return this.innerModel().lastCompletionTime();
    }

    @Override
    public OffsetDateTime lastStartedTime() {
        return this.innerModel().lastStartedTime();
    }

    @Override
    public Integer totalErrors() {
        return this.innerModel().totalErrors();
    }

    @Override
    public Integer totalConflicts() {
        return this.innerModel().totalConflicts();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ImportJobInner innerModel() {
        return this.innerObject;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public ImportJobImpl withExistingAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        this.resourceGroupName = resourceGroupName;
        this.amlFilesystemName = amlFilesystemName;
        return this;
    }

    @Override
    public ImportJob create() {
        this.innerObject = this.serviceManager.serviceClient().getImportJobs().createOrUpdate(this.resourceGroupName, this.amlFilesystemName, this.importJobName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ImportJob create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getImportJobs().createOrUpdate(this.resourceGroupName, this.amlFilesystemName, this.importJobName, this.innerModel(), context);
        return this;
    }

    ImportJobImpl(String name, StorageCacheManager serviceManager) {
        this.innerObject = new ImportJobInner();
        this.serviceManager = serviceManager;
        this.importJobName = name;
    }

    @Override
    public ImportJobImpl update() {
        this.updateImportJob = new ImportJobUpdate();
        return this;
    }

    @Override
    public ImportJob apply() {
        this.innerObject = this.serviceManager.serviceClient().getImportJobs().update(this.resourceGroupName, this.amlFilesystemName, this.importJobName, this.updateImportJob, Context.NONE);
        return this;
    }

    @Override
    public ImportJob apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getImportJobs().update(this.resourceGroupName, this.amlFilesystemName, this.importJobName, this.updateImportJob, context);
        return this;
    }

    ImportJobImpl(ImportJobInner innerObject, StorageCacheManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "amlFilesystems");
        this.importJobName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "importJobs");
    }

    @Override
    public ImportJob refresh() {
        this.innerObject = (ImportJobInner)((Object)this.serviceManager.serviceClient().getImportJobs().getWithResponse(this.resourceGroupName, this.amlFilesystemName, this.importJobName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ImportJob refresh(Context context) {
        this.innerObject = (ImportJobInner)((Object)this.serviceManager.serviceClient().getImportJobs().getWithResponse(this.resourceGroupName, this.amlFilesystemName, this.importJobName, context).getValue());
        return this;
    }

    @Override
    public ImportJobImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ImportJobImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ImportJobImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateImportJob.withTags(tags);
        return this;
    }

    @Override
    public ImportJobImpl withAdminStatus(ImportJobAdminStatus adminStatus) {
        if (this.isInCreateMode()) {
            this.innerModel().withAdminStatus(adminStatus);
            return this;
        }
        this.updateImportJob.withAdminStatus(adminStatus);
        return this;
    }

    @Override
    public ImportJobImpl withImportPrefixes(List<String> importPrefixes) {
        this.innerModel().withImportPrefixes(importPrefixes);
        return this;
    }

    @Override
    public ImportJobImpl withConflictResolutionMode(ConflictResolutionMode conflictResolutionMode) {
        this.innerModel().withConflictResolutionMode(conflictResolutionMode);
        return this;
    }

    @Override
    public ImportJobImpl withMaximumErrors(Integer maximumErrors) {
        this.innerModel().withMaximumErrors(maximumErrors);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

