/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.models.CacheInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.Cache;
import com.azure.resourcemanager.storagecache.models.CacheDirectorySettings;
import com.azure.resourcemanager.storagecache.models.CacheEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.CacheHealth;
import com.azure.resourcemanager.storagecache.models.CacheIdentity;
import com.azure.resourcemanager.storagecache.models.CacheNetworkSettings;
import com.azure.resourcemanager.storagecache.models.CacheSecuritySettings;
import com.azure.resourcemanager.storagecache.models.CacheSku;
import com.azure.resourcemanager.storagecache.models.CacheUpgradeSettings;
import com.azure.resourcemanager.storagecache.models.CacheUpgradeStatus;
import com.azure.resourcemanager.storagecache.models.PrimingJob;
import com.azure.resourcemanager.storagecache.models.PrimingJobIdParameter;
import com.azure.resourcemanager.storagecache.models.ProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.StorageTargetSpaceAllocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CacheImpl
implements Cache,
Cache.Definition,
Cache.Update {
    private CacheInner innerObject;
    private final StorageCacheManager serviceManager;
    private String resourceGroupName;
    private String cacheName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public CacheIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public CacheSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public Integer cacheSizeGB() {
        return this.innerModel().cacheSizeGB();
    }

    @Override
    public CacheHealth health() {
        return this.innerModel().health();
    }

    @Override
    public List<String> mountAddresses() {
        List<String> inner = this.innerModel().mountAddresses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ProvisioningStateType provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String subnet() {
        return this.innerModel().subnet();
    }

    @Override
    public CacheUpgradeStatus upgradeStatus() {
        return this.innerModel().upgradeStatus();
    }

    @Override
    public CacheUpgradeSettings upgradeSettings() {
        return this.innerModel().upgradeSettings();
    }

    @Override
    public CacheNetworkSettings networkSettings() {
        return this.innerModel().networkSettings();
    }

    @Override
    public CacheEncryptionSettings encryptionSettings() {
        return this.innerModel().encryptionSettings();
    }

    @Override
    public CacheSecuritySettings securitySettings() {
        return this.innerModel().securitySettings();
    }

    @Override
    public CacheDirectorySettings directoryServicesSettings() {
        return this.innerModel().directoryServicesSettings();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<PrimingJob> primingJobs() {
        List<PrimingJob> inner = this.innerModel().primingJobs();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<StorageTargetSpaceAllocation> spaceAllocation() {
        List<StorageTargetSpaceAllocation> inner = this.innerModel().spaceAllocation();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CacheInner innerModel() {
        return this.innerObject;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public CacheImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Cache create() {
        this.innerObject = this.serviceManager.serviceClient().getCaches().createOrUpdate(this.resourceGroupName, this.cacheName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Cache create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaches().createOrUpdate(this.resourceGroupName, this.cacheName, this.innerModel(), context);
        return this;
    }

    CacheImpl(String name, StorageCacheManager serviceManager) {
        this.innerObject = new CacheInner();
        this.serviceManager = serviceManager;
        this.cacheName = name;
    }

    @Override
    public CacheImpl update() {
        return this;
    }

    @Override
    public Cache apply() {
        this.innerObject = this.serviceManager.serviceClient().getCaches().update(this.resourceGroupName, this.cacheName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Cache apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCaches().update(this.resourceGroupName, this.cacheName, this.innerModel(), context);
        return this;
    }

    CacheImpl(CacheInner innerObject, StorageCacheManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.cacheName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "caches");
    }

    @Override
    public Cache refresh() {
        this.innerObject = (CacheInner)((Object)this.serviceManager.serviceClient().getCaches().getByResourceGroupWithResponse(this.resourceGroupName, this.cacheName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Cache refresh(Context context) {
        this.innerObject = (CacheInner)((Object)this.serviceManager.serviceClient().getCaches().getByResourceGroupWithResponse(this.resourceGroupName, this.cacheName, context).getValue());
        return this;
    }

    @Override
    public void debugInfo() {
        this.serviceManager.caches().debugInfo(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void debugInfo(Context context) {
        this.serviceManager.caches().debugInfo(this.resourceGroupName, this.cacheName, context);
    }

    @Override
    public void flush() {
        this.serviceManager.caches().flush(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void flush(Context context) {
        this.serviceManager.caches().flush(this.resourceGroupName, this.cacheName, context);
    }

    @Override
    public void start() {
        this.serviceManager.caches().start(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void start(Context context) {
        this.serviceManager.caches().start(this.resourceGroupName, this.cacheName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.caches().stop(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void stop(Context context) {
        this.serviceManager.caches().stop(this.resourceGroupName, this.cacheName, context);
    }

    @Override
    public void startPrimingJob() {
        this.serviceManager.caches().startPrimingJob(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void startPrimingJob(PrimingJob primingjob, Context context) {
        this.serviceManager.caches().startPrimingJob(this.resourceGroupName, this.cacheName, primingjob, context);
    }

    @Override
    public void stopPrimingJob() {
        this.serviceManager.caches().stopPrimingJob(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void stopPrimingJob(PrimingJobIdParameter primingJobId, Context context) {
        this.serviceManager.caches().stopPrimingJob(this.resourceGroupName, this.cacheName, primingJobId, context);
    }

    @Override
    public void pausePrimingJob() {
        this.serviceManager.caches().pausePrimingJob(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void pausePrimingJob(PrimingJobIdParameter primingJobId, Context context) {
        this.serviceManager.caches().pausePrimingJob(this.resourceGroupName, this.cacheName, primingJobId, context);
    }

    @Override
    public void resumePrimingJob() {
        this.serviceManager.caches().resumePrimingJob(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void resumePrimingJob(PrimingJobIdParameter primingJobId, Context context) {
        this.serviceManager.caches().resumePrimingJob(this.resourceGroupName, this.cacheName, primingJobId, context);
    }

    @Override
    public void upgradeFirmware() {
        this.serviceManager.caches().upgradeFirmware(this.resourceGroupName, this.cacheName);
    }

    @Override
    public void upgradeFirmware(Context context) {
        this.serviceManager.caches().upgradeFirmware(this.resourceGroupName, this.cacheName, context);
    }

    @Override
    public CacheImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public CacheImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public CacheImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public CacheImpl withIdentity(CacheIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public CacheImpl withSku(CacheSku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public CacheImpl withCacheSizeGB(Integer cacheSizeGB) {
        this.innerModel().withCacheSizeGB(cacheSizeGB);
        return this;
    }

    @Override
    public CacheImpl withSubnet(String subnet) {
        this.innerModel().withSubnet(subnet);
        return this;
    }

    @Override
    public CacheImpl withUpgradeSettings(CacheUpgradeSettings upgradeSettings) {
        this.innerModel().withUpgradeSettings(upgradeSettings);
        return this;
    }

    @Override
    public CacheImpl withNetworkSettings(CacheNetworkSettings networkSettings) {
        this.innerModel().withNetworkSettings(networkSettings);
        return this;
    }

    @Override
    public CacheImpl withEncryptionSettings(CacheEncryptionSettings encryptionSettings) {
        this.innerModel().withEncryptionSettings(encryptionSettings);
        return this;
    }

    @Override
    public CacheImpl withSecuritySettings(CacheSecuritySettings securitySettings) {
        this.innerModel().withSecuritySettings(securitySettings);
        return this;
    }

    @Override
    public CacheImpl withDirectoryServicesSettings(CacheDirectorySettings directoryServicesSettings) {
        this.innerModel().withDirectoryServicesSettings(directoryServicesSettings);
        return this;
    }

    @Override
    public CacheImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }
}

