/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.AutoImportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.models.AutoImportJobInner;
import com.azure.resourcemanager.storagecache.implementation.AutoImportJobImpl;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.AutoImportJob;
import com.azure.resourcemanager.storagecache.models.AutoImportJobs;

public final class AutoImportJobsImpl
implements AutoImportJobs {
    private static final ClientLogger LOGGER = new ClientLogger(AutoImportJobsImpl.class);
    private final AutoImportJobsClient innerClient;
    private final StorageCacheManager serviceManager;

    public AutoImportJobsImpl(AutoImportJobsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        this.serviceClient().delete(resourceGroupName, amlFilesystemName, autoImportJobName);
    }

    @Override
    public void delete(String resourceGroupName, String amlFilesystemName, String autoImportJobName, Context context) {
        this.serviceClient().delete(resourceGroupName, amlFilesystemName, autoImportJobName, context);
    }

    @Override
    public Response<AutoImportJob> getWithResponse(String resourceGroupName, String amlFilesystemName, String autoImportJobName, Context context) {
        Response<AutoImportJobInner> inner = this.serviceClient().getWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AutoImportJobImpl((AutoImportJobInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AutoImportJob get(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        AutoImportJobInner inner = this.serviceClient().get(resourceGroupName, amlFilesystemName, autoImportJobName);
        if (inner != null) {
            return new AutoImportJobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AutoImportJob> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        PagedIterable<AutoImportJobInner> inner = this.serviceClient().listByAmlFilesystem(resourceGroupName, amlFilesystemName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutoImportJobImpl((AutoImportJobInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AutoImportJob> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName, Context context) {
        PagedIterable<AutoImportJobInner> inner = this.serviceClient().listByAmlFilesystem(resourceGroupName, amlFilesystemName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutoImportJobImpl((AutoImportJobInner)((Object)inner1), this.manager()));
    }

    @Override
    public AutoImportJob getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String autoImportJobName = ResourceManagerUtils.getValueFromIdByName(id, "autoImportJobs");
        if (autoImportJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoImportJobs'.", id)));
        }
        return (AutoImportJob)this.getWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, Context.NONE).getValue();
    }

    @Override
    public Response<AutoImportJob> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String autoImportJobName = ResourceManagerUtils.getValueFromIdByName(id, "autoImportJobs");
        if (autoImportJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoImportJobs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String autoImportJobName = ResourceManagerUtils.getValueFromIdByName(id, "autoImportJobs");
        if (autoImportJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoImportJobs'.", id)));
        }
        this.delete(resourceGroupName, amlFilesystemName, autoImportJobName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String autoImportJobName = ResourceManagerUtils.getValueFromIdByName(id, "autoImportJobs");
        if (autoImportJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoImportJobs'.", id)));
        }
        this.delete(resourceGroupName, amlFilesystemName, autoImportJobName, context);
    }

    private AutoImportJobsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutoImportJobImpl define(String name) {
        return new AutoImportJobImpl(name, this.manager());
    }
}

