/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.models.AutoImportJobInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.AutoImportJob;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesAdminStatus;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesProvisioningState;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesStatusBlobSyncEvents;
import com.azure.resourcemanager.storagecache.models.AutoImportJobState;
import com.azure.resourcemanager.storagecache.models.AutoImportJobUpdate;
import com.azure.resourcemanager.storagecache.models.AutoImportJobUpdatePropertiesAdminStatus;
import com.azure.resourcemanager.storagecache.models.ConflictResolutionMode;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class AutoImportJobImpl
implements AutoImportJob,
AutoImportJob.Definition,
AutoImportJob.Update {
    private AutoImportJobInner innerObject;
    private final StorageCacheManager serviceManager;
    private String resourceGroupName;
    private String amlFilesystemName;
    private String autoImportJobName;
    private AutoImportJobUpdate updateAutoImportJob;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AutoImportJobPropertiesProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public AutoImportJobPropertiesAdminStatus adminStatus() {
        return this.innerModel().adminStatus();
    }

    @Override
    public List<String> autoImportPrefixes() {
        List<String> inner = this.innerModel().autoImportPrefixes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ConflictResolutionMode conflictResolutionMode() {
        return this.innerModel().conflictResolutionMode();
    }

    @Override
    public Boolean enableDeletions() {
        return this.innerModel().enableDeletions();
    }

    @Override
    public Long maximumErrors() {
        return this.innerModel().maximumErrors();
    }

    @Override
    public AutoImportJobState state() {
        return this.innerModel().state();
    }

    @Override
    public String statusCode() {
        return this.innerModel().statusCode();
    }

    @Override
    public String statusMessage() {
        return this.innerModel().statusMessage();
    }

    @Override
    public OffsetDateTime scanStartTime() {
        return this.innerModel().scanStartTime();
    }

    @Override
    public OffsetDateTime scanEndTime() {
        return this.innerModel().scanEndTime();
    }

    @Override
    public Long totalBlobsWalked() {
        return this.innerModel().totalBlobsWalked();
    }

    @Override
    public Long rateOfBlobWalk() {
        return this.innerModel().rateOfBlobWalk();
    }

    @Override
    public Long totalBlobsImported() {
        return this.innerModel().totalBlobsImported();
    }

    @Override
    public Long rateOfBlobImport() {
        return this.innerModel().rateOfBlobImport();
    }

    @Override
    public Long importedFiles() {
        return this.innerModel().importedFiles();
    }

    @Override
    public Long importedDirectories() {
        return this.innerModel().importedDirectories();
    }

    @Override
    public Long importedSymlinks() {
        return this.innerModel().importedSymlinks();
    }

    @Override
    public Long preexistingFiles() {
        return this.innerModel().preexistingFiles();
    }

    @Override
    public Long preexistingDirectories() {
        return this.innerModel().preexistingDirectories();
    }

    @Override
    public Long preexistingSymlinks() {
        return this.innerModel().preexistingSymlinks();
    }

    @Override
    public Long totalErrors() {
        return this.innerModel().totalErrors();
    }

    @Override
    public Long totalConflicts() {
        return this.innerModel().totalConflicts();
    }

    @Override
    public AutoImportJobPropertiesStatusBlobSyncEvents blobSyncEvents() {
        return this.innerModel().blobSyncEvents();
    }

    @Override
    public OffsetDateTime lastStartedTimeUtc() {
        return this.innerModel().lastStartedTimeUtc();
    }

    @Override
    public OffsetDateTime lastCompletionTimeUtc() {
        return this.innerModel().lastCompletionTimeUtc();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AutoImportJobInner innerModel() {
        return this.innerObject;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutoImportJobImpl withExistingAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        this.resourceGroupName = resourceGroupName;
        this.amlFilesystemName = amlFilesystemName;
        return this;
    }

    @Override
    public AutoImportJob create() {
        this.innerObject = this.serviceManager.serviceClient().getAutoImportJobs().createOrUpdate(this.resourceGroupName, this.amlFilesystemName, this.autoImportJobName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AutoImportJob create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAutoImportJobs().createOrUpdate(this.resourceGroupName, this.amlFilesystemName, this.autoImportJobName, this.innerModel(), context);
        return this;
    }

    AutoImportJobImpl(String name, StorageCacheManager serviceManager) {
        this.innerObject = new AutoImportJobInner();
        this.serviceManager = serviceManager;
        this.autoImportJobName = name;
    }

    @Override
    public AutoImportJobImpl update() {
        this.updateAutoImportJob = new AutoImportJobUpdate();
        return this;
    }

    @Override
    public AutoImportJob apply() {
        this.innerObject = this.serviceManager.serviceClient().getAutoImportJobs().update(this.resourceGroupName, this.amlFilesystemName, this.autoImportJobName, this.updateAutoImportJob, Context.NONE);
        return this;
    }

    @Override
    public AutoImportJob apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAutoImportJobs().update(this.resourceGroupName, this.amlFilesystemName, this.autoImportJobName, this.updateAutoImportJob, context);
        return this;
    }

    AutoImportJobImpl(AutoImportJobInner innerObject, StorageCacheManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "amlFilesystems");
        this.autoImportJobName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "autoImportJobs");
    }

    @Override
    public AutoImportJob refresh() {
        this.innerObject = (AutoImportJobInner)((Object)this.serviceManager.serviceClient().getAutoImportJobs().getWithResponse(this.resourceGroupName, this.amlFilesystemName, this.autoImportJobName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AutoImportJob refresh(Context context) {
        this.innerObject = (AutoImportJobInner)((Object)this.serviceManager.serviceClient().getAutoImportJobs().getWithResponse(this.resourceGroupName, this.amlFilesystemName, this.autoImportJobName, context).getValue());
        return this;
    }

    @Override
    public AutoImportJobImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public AutoImportJobImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public AutoImportJobImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateAutoImportJob.withTags(tags);
        return this;
    }

    @Override
    public AutoImportJobImpl withAdminStatus(AutoImportJobPropertiesAdminStatus adminStatus) {
        this.innerModel().withAdminStatus(adminStatus);
        return this;
    }

    @Override
    public AutoImportJobImpl withAutoImportPrefixes(List<String> autoImportPrefixes) {
        this.innerModel().withAutoImportPrefixes(autoImportPrefixes);
        return this;
    }

    @Override
    public AutoImportJobImpl withConflictResolutionMode(ConflictResolutionMode conflictResolutionMode) {
        this.innerModel().withConflictResolutionMode(conflictResolutionMode);
        return this;
    }

    @Override
    public AutoImportJobImpl withEnableDeletions(Boolean enableDeletions) {
        this.innerModel().withEnableDeletions(enableDeletions);
        return this;
    }

    @Override
    public AutoImportJobImpl withMaximumErrors(Long maximumErrors) {
        this.innerModel().withMaximumErrors(maximumErrors);
        return this;
    }

    @Override
    public AutoImportJobImpl withAdminStatus(AutoImportJobUpdatePropertiesAdminStatus adminStatus) {
        this.updateAutoImportJob.withAdminStatus(adminStatus);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

